

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientHasConnectivityIssue.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: scgV2ClientHasConnectivityIssue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientHasConnectivityIssue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientHasConnectivityIssue]
  delete from GXDBVersions where name = 'scgV2ClientHasConnectivityIssue' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2ClientHasConnectivityIssue(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	-- Get Client latest Max CCRId
	DECLARE @ccrTbl TABLE (
		clientId		INT,
		latestCCRId		INT,
		PRIMARY KEY(latestCCRId, clientId)
	)
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		INSERT INTO @ccrTbl (clientId, latestCCRId)
			SELECT
				s.clientId,
				MAX(s.CCRId) latestCCRId
			FROM APP_Client cl WITH(NOLOCK)
				INNER JOIN CCRToSubClient s WITH(NOLOCK) ON
					s.ClientId = cl.id
				INNER JOIN CCRCommCellReadiness c ON
					c.CCRId = s.CCRId
					AND c.CCREndTime > 0
			WHERE
				(cl.status & (2|4)) > 0		-- exclude uninstalled and deleted clients
			GROUP BY
				s.clientId
	END
	ELSE
	BEGIN
		-- Single Client
		INSERT INTO @ccrTbl (clientId, latestCCRId)
			SELECT
				s.clientId,
				MAX(s.CCRId) latestCCRId
			FROM APP_Client cl WITH(NOLOCK)
				INNER JOIN CCRToSubClient s WITH(NOLOCK) ON
					s.ClientId = cl.id
					AND cl.id = @inClientId
				INNER JOIN CCRCommCellReadiness c ON
					c.CCRId = s.CCRId
					AND c.CCREndTime > 0
			WHERE
				(cl.status & (2|4)) > 0		-- exclude uninstalled and deleted clients
			GROUP BY
				s.clientId
	END
	IF (@compValue > 0)
	BEGIN
		-- true - Not Ready
		INSERT INTO @clientIds
			SELECT DISTINCT
				s.ClientId
			FROM @ccrTbl c
				INNER JOIN CCRToSubClient s WITH(NOLOCK) ON
					s.CCRId = c.latestCCRId
					AND s.clientId = c.clientId
			GROUP BY
				s.ClientId,
				s.SubClientId
			HAVING
				MIN(s.CCRResultFlag) <> 0
	END
	ELSE
	BEGIN
		-- false - Ready
		IF (@inClientId = 0)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
				WHERE
					c.id > 1
					AND (c.status & (2|4)) > 0		-- exclude uninstalled and deleted clients
				EXCEPT
				SELECT DISTINCT	-- Remove Not ready clients
					s.ClientId
				FROM @ccrTbl c
					INNER JOIN CCRToSubClient s WITH(NOLOCK) ON
						s.CCRId = c.latestCCRId
						AND s.clientId = c.clientId
				GROUP BY
					s.ClientId,
					s.SubClientId
				HAVING
					MIN(s.CCRResultFlag) <> 0
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
				WHERE
					c.id = @inClientId
					AND (c.status & (2|4)) > 0		-- exclude uninstalled and deleted clients
				EXCEPT
				SELECT DISTINCT	-- Remove Not ready clients
					s.ClientId
				FROM @ccrTbl c
					INNER JOIN CCRToSubClient s WITH(NOLOCK) ON
						s.CCRId = c.latestCCRId
						AND s.clientId = c.clientId
				GROUP BY
					s.ClientId,
					s.SubClientId
				HAVING
					MIN(s.CCRResultFlag) <> 0
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientHasConnectivityIssue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientHasConnectivityIssue' AND revision = '1.1.2.6')

  insert into GXDBVersions values(5, 'scgV2ClientHasConnectivityIssue',  '1.1.2.6', 'scgV2ClientHasConnectivityIssue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
