

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientBackupActivityEnabled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientBackupActivityEnabled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientBackupActivityEnabled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientBackupActivityEnabled]
  delete from GXDBVersions where name = 'scgV2ClientBackupActivityEnabled' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2ClientBackupActivityEnabled(@operator VARCHAR(24), @compValue INT,@inClientID INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @cgBackupsDisabled TABLE (
		cgId		INT PRIMARY KEY
	)
	-- Client Groups are only marked disabled with an actual row, if no row they are enabled
	INSERT INTO @cgBackupsDisabled (cgId)
		SELECT DISTINCT
			cg.id
		FROM APP_ClientGroup cg WITH(READUNCOMMITTED)
			INNER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
				ja.clientId = 1
				AND ja.mediaAgentID = 1
				AND ja.clientGroupId = cg.id
				AND ja.appType = 0
				AND ja.opType = 4			-- CVOpType::BACKUP. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				AND (ja.action & 2) = 0		-- backup disabled
		WHERE
			cg.id <> @inSCGId		-- Exclude self - allows clients to leave this client group so that we do not inherit from self
	IF (@inClientID=0)
	BEGIN
		IF (@compValue > 0)
		BEGIN
			-- Backup Enabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN  (
						SELECT
							cga.clientId
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN @cgBackupsDisabled d ON
								d.cgId = cga.clientGroupId
					) d ON
						d.clientId = c.id
				WHERE
					c.id <> 1
					AND (c.[status] & (2|4)) = 0	-- uninstalled/deleted/agentless client
					AND d.clientId IS NULL
				EXCEPT	-- Remove Clients with Backup disabled
				SELECT
					c.id
				FROM dbo.scgV2BackupActivityForClient('FALSE', 0, @inClientID, @inSCGId) g
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = g.clientId
						AND (c.[status] & (2|4)) = 0	-- uninstalled/deleted/agentless client
		END
		ELSE
		BEGIN
			-- Backup Disabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN  (
						SELECT
							cga.clientId
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN @cgBackupsDisabled d ON
								d.cgId = cga.clientGroupId
					) d ON
						d.clientId = c.id
				WHERE
					c.id <> 1
					AND (c.[status] & (2|4)) = 0	-- uninstalled/deleted/agentless client
				UNION
				SELECT
					c.id
				FROM dbo.scgV2BackupActivityForClient('FALSE', 0, @inClientID, @inSCGId) g
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = g.clientId
						AND (c.[status] & (2|4)) = 0	-- uninstalled/deleted/agentless client
		END
    END
	ELSE
	BEGIN
		IF (@compValue > 0)
		BEGIN
			-- Backup Enabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN  (
						SELECT
							cga.clientId
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN @cgBackupsDisabled d ON
								d.cgId = cga.clientGroupId
					) d ON
						d.clientId = c.id
				WHERE
					c.id = @inClientID
					AND (c.[status] & (2|4)) = 0	-- uninstalled/deleted/agentless client
					AND d.clientId IS NULL
				EXCEPT	-- Remove Clients with Backup disabled
				SELECT
					c.id
				FROM dbo.scgV2BackupActivityForClient('FALSE', 0, @inClientID, @inSCGId) g
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = g.clientId
						AND (c.[status] & (2|4)) = 0	-- uninstalled/deleted/agentless client
						AND c.id = @inClientID
		END
		ELSE
		BEGIN
			-- Backup Disabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN  (
						SELECT
							cga.clientId
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN @cgBackupsDisabled d ON
								d.cgId = cga.clientGroupId
					) d ON
						d.clientId = c.id
				WHERE
					c.id = @inClientID
					AND (c.[status] & (2|4)) = 0	-- uninstalled/deleted/agentless client
				UNION
				SELECT
					c.id
				FROM dbo.scgV2BackupActivityForClient('FALSE', 0, @inClientID, @inSCGId) g
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = g.clientId
						AND (c.[status] & (2|4)) = 0	-- uninstalled/deleted/agentless client
						AND c.id = @inClientID
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientBackupActivityEnabled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientBackupActivityEnabled' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'scgV2ClientBackupActivityEnabled',  '1.1.2.1', 'scgV2ClientBackupActivityEnabled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
