

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2CheckPackageInstalled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2CheckPackageInstalled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2CheckPackageInstalled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2CheckPackageInstalled]
  delete from GXDBVersions where name = 'scgV2CheckPackageInstalled' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2CheckPackageInstalled(@operator varchar(24), @packagesXml XML,@inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @packageDisplay TABLE (displayId INT PRIMARY KEY)
	INSERT INTO @packageDisplay(displayId)
		SELECT ref.value('@val' , 'int')
		FROM @packagesXml.nodes('App_AdvanceKeyInfo/packages') R(ref)
	DECLARE @packages TABLE (package INT PRIMARY KEY)
	-- Get all packages that share the same DisplayName Grouping
	INSERT INTO @packages (package)
		SELECT
			p.id
		FROM simPackage p WITH(NOLOCK)
		WHERE
			p.DisplayName IN (
				SELECT
					DisplayName
				FROM simPackage WITH(NOLOCK)
					INNER JOIN @packageDisplay ON
						displayId = id
				)
	IF (@inClientId=0 )
	BEGIN
		IF (@operator = '=')
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
						ip.clientId = c.id
					INNER JOIN @packages p ON
						p.package = ip.simPackageID
				WHERE
					c.id <> 1
				UNION
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
						ip.clientId = c.id
					INNER JOIN simPackage p WITH(READUNCOMMITTED) ON
						p.id = ip.simPackageID
					INNER JOIN simPackage p2 WITH(READUNCOMMITTED) ON
						p2.Name = p.Name
					INNER JOIN @packages pt ON
						pt.package = p2.id
				WHERE
					c.id <> 1
		END
		ELSE
		BEGIN
			-- not equal '<>'
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				EXCEPT
				(
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
							ip.clientId = c.id
						INNER JOIN @packages p ON
							p.package = ip.simPackageID
					WHERE
						c.id <> 1
					UNION
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
							ip.clientId = c.id
						INNER JOIN simPackage p WITH(READUNCOMMITTED) ON
							p.id = ip.simPackageID
						INNER JOIN simPackage p2 WITH(READUNCOMMITTED) ON
							p2.Name = p.Name
						INNER JOIN @packages pt ON
							pt.package = p2.id
					WHERE
						c.id <> 1
				)
		END
	END
	ELSE
	BEGIN
		IF (@operator = '=')
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
						ip.clientId = c.id
					INNER JOIN @packages p ON
						p.package = ip.simPackageID
				WHERE
					c.id <> 1 AND c.id=@inClientId
				UNION
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
						ip.clientId = c.id
					INNER JOIN simPackage p WITH(READUNCOMMITTED) ON
						p.id = ip.simPackageID
					INNER JOIN simPackage p2 WITH(READUNCOMMITTED) ON
						p2.Name = p.Name
					INNER JOIN @packages pt ON
						pt.package = p2.id
				WHERE
					c.id <> 1 AND c.id=@inClientId
		END
		ELSE
		BEGIN
			-- not equal '<>'
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE   c.id=@inClientId
				EXCEPT
				(
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
							ip.clientId = c.id
						INNER JOIN @packages p ON
							p.package = ip.simPackageID
					WHERE
						c.id <> 1 AND c.id=@inClientId
					UNION
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
							ip.clientId = c.id
						INNER JOIN simPackage p WITH(READUNCOMMITTED) ON
							p.id = ip.simPackageID
						INNER JOIN simPackage p2 WITH(READUNCOMMITTED) ON
							p2.Name = p.Name
						INNER JOIN @packages pt ON
							pt.package = p2.id
					WHERE
						c.id <> 1 AND c.id=@inClientId
				)
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2CheckPackageInstalled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2CheckPackageInstalled' AND revision = '')

  insert into GXDBVersions values(5, 'scgV2CheckPackageInstalled',  '', 'scgV2CheckPackageInstalled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
