

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2CheckClientInStoragePolicyList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2CheckClientInStoragePolicyList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2CheckClientInStoragePolicyList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2CheckClientInStoragePolicyList]
  delete from GXDBVersions where name = 'scgV2CheckClientInStoragePolicyList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2CheckClientInStoragePolicyList(@operator varchar(16), @compValue XML,@inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @Policies TABLE (
		id	INT PRIMARY KEY
	)
	INSERT INTO @Policies (id)
		SELECT
			cg.value('@val', 'integer')
		FROM
			@compValue.nodes('/App_SCGRuleValueList/id')	l(cg)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- no storage policies nothing to do
		RETURN
	END
	IF (@inClientId=0 )
	BEGIN
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND NOT (
							-- Exclude SubClient Policies
							a.clientId = 2
							AND a.appTypeId = 1030
						)
					INNER JOIN archGroup ag WITH(READUNCOMMITTED) ON
						ag.id = a.dataArchGrpID
					INNER JOIN @Policies p ON
						p.id = ag.id
				WHERE
					c.id > 1
				UNION
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND NOT (
							-- Exclude SubClient Policies
							a.clientId = 2
							AND a.appTypeId = 1030
						)
					INNER JOIN archGroup ag WITH(READUNCOMMITTED) ON
						ag.id = a.logArchGrpID
					INNER JOIN @Policies p ON
						p.id = ag.id
				WHERE
					c.id > 1
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				(
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
							a.clientId = c.id
							AND NOT (
								-- Exclude SubClient Policies
								a.clientId = 2
								AND a.appTypeId = 1030
							)
						INNER JOIN archGroup ag WITH(READUNCOMMITTED) ON
							ag.id = a.dataArchGrpID
						INNER JOIN @Policies p ON
							p.id = ag.id
					WHERE
						c.id > 1
					UNION ALL
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
							a.clientId = c.id
							AND NOT (
								-- Exclude SubClient Policies
								a.clientId = 2
								AND a.appTypeId = 1030
							)
						INNER JOIN archGroup ag WITH(READUNCOMMITTED) ON
							ag.id = a.logArchGrpID
						INNER JOIN @Policies p ON
							p.id = ag.id
					WHERE
						c.id > 1
				)
		END
	END
	ELSE
	BEGIN
	IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND NOT (
							-- Exclude SubClient Policies
							a.clientId = 2
							AND a.appTypeId = 1030
						)
					INNER JOIN archGroup ag WITH(READUNCOMMITTED) ON
						ag.id = a.dataArchGrpID
					INNER JOIN @Policies p ON
						p.id = ag.id
				WHERE
					c.id > 1 AND c.id=@inClientId
				UNION
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND NOT (
							-- Exclude SubClient Policies
							a.clientId = 2
							AND a.appTypeId = 1030
						)
					INNER JOIN archGroup ag WITH(READUNCOMMITTED) ON
						ag.id = a.logArchGrpID
					INNER JOIN @Policies p ON
						p.id = ag.id
				WHERE
					c.id > 1 AND c.id=@inClientId
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1 AND c.id=@inClientId
				EXCEPT
				(
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
							a.clientId = c.id
							AND NOT (
								-- Exclude SubClient Policies
								a.clientId = 2
								AND a.appTypeId = 1030
							)
						INNER JOIN archGroup ag WITH(READUNCOMMITTED) ON
							ag.id = a.dataArchGrpID
						INNER JOIN @Policies p ON
							p.id = ag.id
					WHERE
						c.id > 1 AND c.id=@inClientId
					UNION ALL
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
							a.clientId = c.id
							AND NOT (
								-- Exclude SubClient Policies
								a.clientId = 2
								AND a.appTypeId = 1030
							)
						INNER JOIN archGroup ag WITH(READUNCOMMITTED) ON
							ag.id = a.logArchGrpID
						INNER JOIN @Policies p ON
							p.id = ag.id
					WHERE
						c.id > 1 AND c.id=@inClientId
				)
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2CheckClientInStoragePolicyList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2CheckClientInStoragePolicyList' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2CheckClientInStoragePolicyList',  '1.1.2.5', 'scgV2CheckClientInStoragePolicyList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
