

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2CheckClientInGroupList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2CheckClientInGroupList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2CheckClientInGroupList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2CheckClientInGroupList]
  delete from GXDBVersions where name = 'scgV2CheckClientInGroupList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2CheckClientInGroupList(@operator varchar(16), @compValue XML,@inClientID INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @ClientGroups TABLE (
		id	INT PRIMARY KEY
	)
	INSERT INTO @ClientGroups (id)
		SELECT
			cg.value('@val', 'integer')
		FROM
			@compValue.nodes('/App_SCGRuleValueList/id')	l(cg)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- no client groups nothing to do
		RETURN
	END
	IF (@inClientID=0 )
	BEGIN
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
						c.id = cga.clientId
					INNER JOIN @ClientGroups cg ON
						cg.id = cga.clientGroupId
				WHERE
					c.id > 1
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
						c.id = cga.clientId
					INNER JOIN @ClientGroups cg ON
						cg.id = cga.clientGroupId
				WHERE
					c.id > 1
		END
	END
	ELSE
	BEGIN
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
						c.id = cga.clientId
					INNER JOIN @ClientGroups cg ON
						cg.id = cga.clientGroupId
				WHERE
					c.id > 1 AND  C.id=@inClientID
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
						c.id = cga.clientId
					INNER JOIN @ClientGroups cg ON
						cg.id = cga.clientGroupId
				WHERE
					c.id > 1 AND  C.id=@inClientID
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2CheckClientInGroupList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2CheckClientInGroupList' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2CheckClientInGroupList',  '1.1.2.4', 'scgV2CheckClientInGroupList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
