

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2CheckClientEncryptionState.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2CheckClientEncryptionState'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2CheckClientEncryptionState]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2CheckClientEncryptionState]
  delete from GXDBVersions where name = 'scgV2CheckClientEncryptionState' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
	CREATE FUNCTION scgV2CheckClientEncryptionState(@operator varchar(16), @compValue integer, @inClientID INT, @inSCGId INT)
	RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
		---- WITH ENCRYPTION
	AS
	BEGIN
		IF (@inClientID = 0)
		BEGIN
			-- All Clients
			IF (@compValue > 0)
				--true
			BEGIN
				INSERT INTO @clientIds
					SELECT ac.id
					FROM APP_Client Ac
						INNER JOIN APP_ClientProp Cp ON
							Ac.id = Cp.componentNameId
					WHERE attrName = N'Encryption Settings'
						AND attrVal = '1'
						AND cp.Modified = 0
						AND ac.Id > 1
			END
			ELSE
			BEGIN
				--false
				INSERT INTO @clientIds
					SELECT c.id clientId
					FROM APP_Client c WITH (READUNCOMMITTED)
					WHERE c.id > 1
					EXCEPT
					(
						SELECT ac.id
						FROM APP_Client Ac WITH (READUNCOMMITTED)
							INNER JOIN APP_ClientProp Cp  WITH (READUNCOMMITTED) ON
								Ac.id = Cp.componentNameId
						WHERE attrName = N'Encryption Settings'
								AND attrVal = '1'
								AND cp.Modified = 0
					)
			END
		END
		ELSE
		BEGIN
			-- Given Client
			IF (@compValue > 0)
				--true
			BEGIN
				INSERT INTO @clientIds
					SELECT ac.id
					FROM APP_Client Ac
						INNER JOIN APP_ClientProp Cp ON
							Ac.id = Cp.componentNameId
							AND Ac.id = @inClientID
					WHERE attrName = N'Encryption Settings'
						AND attrVal = '1'
						AND cp.Modified = 0
						AND ac.Id > 1
			END
			ELSE
			BEGIN
				--false
				INSERT INTO @clientIds
					SELECT c.id clientId
					FROM APP_Client c WITH (READUNCOMMITTED)
					WHERE c.id = @inClientID
					EXCEPT
					(
						SELECT ac.id
						FROM APP_Client Ac WITH (READUNCOMMITTED)
							INNER JOIN APP_ClientProp Cp  WITH (READUNCOMMITTED) ON
								Ac.id = Cp.componentNameId
								AND Ac.id = @inClientID
						WHERE attrName = N'Encryption Settings'
								AND attrVal = '1'
								AND cp.Modified = 0
					)
			END
		END
		RETURN
	END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2CheckClientEncryptionState]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2CheckClientEncryptionState' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'scgV2CheckClientEncryptionState',  '1.1.2.3', 'scgV2CheckClientEncryptionState', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
