

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2BackupActivityForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2BackupActivityForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2BackupActivityForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2BackupActivityForClient]
  delete from GXDBVersions where name = 'scgV2BackupActivityForClient' and type = 5
END
GO

	CREATE FUNCTION scgV2BackupActivityForClient(@operator VARCHAR(24), @compValue INT,@inClientID INT, @inSCGId INT)
	RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
	-- WITH ENCRYPTION
	AS
	BEGIN
	IF (@inClientID=0)
	BEGIN
		IF (@compValue > 0)
		BEGIN
			-- Backup Enabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
						c.id = ja.clientId
						AND ja.appType = 0
						AND ja.opType = 4	-- CVOpType::BACKUP. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				WHERE
					c.id <> 1
					AND (ja.action & 2) = 2
		END
		ELSE
		BEGIN
			-- Backup Disabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
						c.id = ja.clientId
						AND ja.appType = 0
						AND ja.opType = 4	-- CVOpType::BACKUP. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				WHERE
					c.id <> 1
					AND (
						ja.action IS NULL
						OR (ja.action & 2) = 0
					)
		END
    END
	ELSE
	BEGIN
		IF (@compValue > 0)
		BEGIN
			-- Backup Enabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
						c.id = ja.clientId
						AND ja.appType = 0
						AND ja.opType = 4	-- CVOpType::BACKUP. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				WHERE
					c.id <> 1
					AND (ja.action & 2) = 2 AND  C.id=@inClientID
		END
		ELSE
		BEGIN
			-- Backup Disabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
						c.id = ja.clientId
						AND ja.appType = 0
						AND ja.opType = 4	-- CVOpType::BACKUP. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				WHERE
					c.id <> 1
					AND (
						ja.action IS NULL
						OR (ja.action & 2) = 0
					) AND  C.id=@inClientID
		END
	END
	RETURN
	END
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2BackupActivityForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2BackupActivityForClient' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2BackupActivityForClient',  '1.1.2.4', 'scgV2BackupActivityForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
