

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgMediaAgentsInGroup.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgMediaAgentsInGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgMediaAgentsInGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgMediaAgentsInGroup]
  delete from GXDBVersions where name = 'scgMediaAgentsInGroup' and type = 5
END
GO

	CREATE FUNCTION scgMediaAgentsInGroup(@clientid INTEGER, @operation NVARCHAR(10), @groupPattern NVARCHAR(1024))
	RETURNS INTEGER
	-- WITH ENCRYPTION
	BEGIN
	    DECLARE @rv INTEGER = 0
	    IF @operation = 'E_WITH'                        BEGIN SET @groupPattern = '%' + @groupPattern END
	    IF @operation = 'S_WITH'                        BEGIN SET @groupPattern = @groupPattern + '%' END
	    IF @operation = 'LIKE' OR @operation = 'N_LIKE' BEGIN SET @groupPattern = '%' + @groupPattern + '%' END
	    -- at the very beginnig verify that client is MA. if client is not MA then it should not be included in group
	    IF EXISTS (SELECT * FROM MMHost WHERE ClientId = @clientid) BEGIN
	        -- get list of groups to be considered
	        DECLARE @temp_Groups TABLE (groupId INTEGER)
	        INSERT INTO @temp_Groups
	            SELECT DISTINCT id FROM APP_ClientGroup WHERE name LIKE @groupPattern ORDER BY id
	        -- for each group verify if client belongs to it
	        DECLARE @currentGroupId INT = (SELECT TOP 1 groupId FROM @temp_Groups ORDER BY groupId)
	        WHILE (@currentGroupId IS NOT NULL) AND @rv = 0 BEGIN
	            -- check if client belongs to a group
	            IF EXISTS (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientGroupId = @currentGroupId AND clientId = @clientid) BEGIN
	                IF (@operation != 'N_LIKE') AND (@operation != '!=') BEGIN
	                    SET @rv = 1
	                END
	            END ELSE BEGIN
	                IF (@operation = 'N_LIKE') OR (@operation = '!=') BEGIN
	                    SET @rv = 1
	                END
	            END
	            -- get next group
	            SET @currentGroupId = (SELECT TOP 1 groupId FROM @temp_Groups WHERE groupId > @currentGroupId ORDER BY groupId)
	        END
	    END
	    RETURN @rv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgMediaAgentsInGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgMediaAgentsInGroup' AND revision = '1.2.2.1')

  insert into GXDBVersions values(5, 'scgMediaAgentsInGroup',  '1.2.2.1', 'scgMediaAgentsInGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
