

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgIsUserClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgIsUserClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgIsUserClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgIsUserClientOwner]
  delete from GXDBVersions where name = 'scgIsUserClientOwner' and type = 5
END
GO

	CREATE FUNCTION scgIsUserClientOwner(@clientId integer, @operation varchar(8), @loginName nvarchar(255) )
	RETURNS INTEGER
	AS
	BEGIN

		DECLARE @result INT = 0

		SELECT TOP 1 @result = 1
		FROM sec_getClientOwnersExpandUG o
		INNER JOIN (
			SELECT DISTINCT u.id
			FROM UMUsers u WITH (NOLOCK)
			WHERE (flags & 1) <> 0
				AND (
						(
						-- For 'N_LIKE' perform LIKE and not results
						(@operation = 'LIKE' OR @operation = 'N_LIKE')
						AND u.login LIKE '%' + @loginName + '%'
						)
					OR (
						-- For '!=' perform LIKE and not results
						(@operation = '=' OR @operation = '!=')
						AND u.login = @loginName
						)
					OR (
						@operation = 'S_WITH'
						AND u.login LIKE @loginName + '%'
						)
					OR (
						@operation = 'E_WITH'
						AND u.login LIKE '%' + @loginName
						)
				)
			) u
			ON o.userId = u.id
				AND o.clientId = @clientId

		IF (@operation = 'N_LIKE' OR @operation = '!=')
		BEGIN
			-- NOT results
			SELECT @result = CASE @result WHEN 1 THEN 0 ELSE 1 END
		END

	RETURN @result
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgIsUserClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgIsUserClientOwner' AND revision = '1.3.42.3')

  insert into GXDBVersions values(5, 'scgIsUserClientOwner',  '1.3.42.3', 'scgIsUserClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
