

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgIsExternalUserGroupClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgIsExternalUserGroupClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgIsExternalUserGroupClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgIsExternalUserGroupClientOwner]
  delete from GXDBVersions where name = 'scgIsExternalUserGroupClientOwner' and type = 5
END
GO

	CREATE FUNCTION scgIsExternalUserGroupClientOwner(@clientId integer, @operation varchar(8), @groupName nvarchar(max) )
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
	--Requirement - Client should have at least one owner as group
	DECLARE @result integer = 0
		IF EXISTS(SELECT * FROM  sec_getClientOwnersExpandUG owners
		WHERE externalGroupId IN
		(
		 (select g.id From UMDSgroups g
		INNER JOIN UMDSProviders p on p.id=g.umdsProviderId
		WHERE  	((@operation = 'LIKE' AND p.domainname + '\' + g.name LIKE '%' + @groupName + '%') OR
	(@operation = 'N_LIKE' AND p.domainname + '\' + g.name  NOT LIKE '%' + @groupName + '%') OR
	(@operation = '=' AND p.domainname + '\' + g.name  = @groupName) OR
	(@operation = '!=' AND p.domainname + '\' + g.name  <> @groupName) OR
	(@operation = 'S_WITH' AND p.domainname + '\' + g.name LIKE  @groupName + '%'	) OR
	(@operation = 'E_WITH' AND p.domainname + '\' + g.name  LIKE   '%' + @groupName 	)
	)))
		 and owners.clientID=@clientId)
	BEGIN
		SET @result = 1
	END
	RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgIsExternalUserGroupClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgIsExternalUserGroupClientOwner' AND revision = '1.3.42.2')

  insert into GXDBVersions values(5, 'scgIsExternalUserGroupClientOwner',  '1.3.42.2', 'scgIsExternalUserGroupClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
