

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgInactiveADUsersAsClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgInactiveADUsersAsClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgInactiveADUsersAsClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgInactiveADUsersAsClientOwner]
  delete from GXDBVersions where name = 'scgInactiveADUsersAsClientOwner' and type = 5
END
GO

	CREATE FUNCTION scgInactiveADUsersAsClientOwner(@clientId integer)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
		IF EXISTS (SELECT
						1
					FROM UMOwners
					WHERE
						entitytype = 3
						AND entityId = @clientId
						AND isUSer = 1
						AND userOrGroupId IN (SELECT id FROM UMusers WHERE (flags & 4) = 0 OR umdsPRoviderID = 0)
		)
		BEGIN
			-- client has active owners
			RETURN 0
		END

		IF EXISTS (SELECT
						1
					FROM UMOwners
					WHERE
						entitytype = 3
						AND entityId = @clientId
						AND isUSer = 1
						AND userOrGroupId IN (SELECT id FROM UMusers WHERE (flags & 4) <> 0 AND umdsPRoviderID <> 0)
		)
		BEGIN
			-- has only inactive owners
			RETURN 1
		END

		RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgInactiveADUsersAsClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgInactiveADUsersAsClientOwner' AND revision = '')

  insert into GXDBVersions values(5, 'scgInactiveADUsersAsClientOwner',  '', 'scgInactiveADUsersAsClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
