

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientProps.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientProps'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientProps]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientProps]
  delete from GXDBVersions where name = 'scgGetClientProps' and type = 5
END
GO

	CREATE FUNCTION scgGetClientProps(@clientId integer, @operation varchar(8), @clientProp integer )
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INTEGER = 0
		DECLARE @propTrue	INTEGER = 0
		IF (@clientProp = 1)
		BEGIN
		DECLARE @rstatus INTEGER = 0
		SET @rstatus = (select specialClientFlags from App_Client with(nolock) where id = @clientId)
		IF ((@operation = '=') AND ((@rstatus&2) = 0))
				SET @result=1
		IF ((@operation = '!=') AND ((@rstatus&2) != 0))
				SET @result=1
		END
		IF (@clientProp = 2)
		BEGIN
		IF EXISTS (select * from APP_Client where id=@clientid and (status&0x2)!=2)
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 3)
		BEGIN
		IF EXISTS (select * from app_clientprop with(nolock) where componentNameId=@clientId and attrName='Virtual Server Discovered Clients' and attrVal='1')
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 4)
		BEGIN
		IF EXISTS (select * from app_clientprop with(nolock) where componentNameId=@clientId and attrName='Installed 1-Touch Server for Windows' and attrVal='1')
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 5)
		BEGIN
		IF EXISTS (SELECT clientId FROM MMhost with(nolock)  WHERE clientId = @clientId AND clientId NOT IN (SELECT PMClientId FROM APP_VMToPMMap with(nolock) WHERE VMClientId = 2) AND clientId > 1)
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 6)
		BEGIN
		IF EXISTS (select * from app_clientprop with(nolock) where componentNameId=@clientId and attrName='Virtual Client' and attrVal='1')
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 7)
		BEGIN
		DECLARE @cstatus INTEGER = 0
		SET @cstatus = (select status from App_Client with(nolock) where id = @clientId)
		IF ((@cstatus & 4096) = 0) --Check if its present in the Client Properties
		BEGIN
		IF EXISTS (select * from app_clientprop with(nolock) where componentNameId=@clientId and attrName='Personal Workstation' and attrVal = '1')
			SET @cstatus = 4096
		END
		IF ((@operation = '=') AND ((@cstatus&0x1000) != 0))
				SET @result=1
		IF ((@operation = '!=') AND ((@cstatus&0x1000) = 0))
				SET @result=1
		END
		IF (@clientProp = 8)
		BEGIN
		DECLARE @isReferenceCopyClient INTEGER = 0
		IF (0x4000000  & (SELECT status FROM APP_Client WHERE id = @clientId)) = 0x4000000
			SET @isReferenceCopyClient = 1
		IF ((@operation = '=') AND (@isReferenceCopyClient = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@isReferenceCopyClient != 1))
				SET @result=1
		END
		IF (@clientProp = 9)
		BEGIN
		DECLARE @isEdgeClient INTEGER = 0
		IF (0x10000000   & (SELECT status FROM APP_Client WHERE id = @clientId)) = 0x10000000
			SET @isEdgeClient = 1
		IF ((@operation = '=') AND (@isEdgeClient = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@isEdgeClient != 1))
				SET @result=1
		END
		IF (@clientProp = 10)
		BEGIN
		DECLARE @simOsId INTEGER = 0
		DECLARE @isNasOs INTEGER = 0
		SET @simOsId = (select simOperatingSystemId from App_Client with(nolock) where id = @clientId)
		IF (SELECT SubType FROM simOperatingSystem WHERE id = @simOsId) = 'NAS'
			SET @isNasOs = 1
		IF ((@operation = '=') AND (@isNasOs = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@isNasOs != 1))
				SET @result=1
		END
		RETURN @result
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientProps]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientProps' AND revision = '1.17.12.3')

  insert into GXDBVersions values(5, 'scgGetClientProps',  '1.17.12.3', 'scgGetClientProps', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
