

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientProductVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientProductVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientProductVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientProductVersion]
  delete from GXDBVersions where name = 'scgGetClientProductVersion' and type = 5
END
GO

	CREATE FUNCTION scgGetClientProductVersion(@i_clientId integer)
	RETURNS NVARCHAR(max)
	-- WITH ENCRYPTION
	AS
	BEGIN
	declare @SPVersionInfo nvarchar(255) = ''
	declare @virtual int = 0
	declare @physicalClientId int = 0
	declare @clientVersion nvarchar(255) = ''
	SELECT	@SPVersionInfo = ISNULL([SP Version Info], N''),
			@virtual = ISNULL([Virtual client], 0),
			@physicalClientId = ISNULL([Active Physical Node], 0),
			@clientVersion = ISNULL([Client Version], N'')
				FROM
				(
							SELECT	componentNameId, attrName, attrVal
									FROM	App_ClientProp with (nolock)
										WHERE	componentNameId = @i_clientId
											AND		modified = 0
				) AS clients
				PIVOT
				(
						MAX(attrVal)
						FOR attrName IN
						(
								[SP Version Info],
								[Virtual client],
								[Active Physical Node],
								[Client Version]

						)
				) AS pvt
	if @virtual = 1
	begin
	    set @SPVersionInfo = (select attrVal from app_clientprop with (nolock) where componentNameId = @physicalClientId and attrName = 'SP Version Info')
	end
	if @SPVersionInfo is NULL or @SPVersionInfo = N''
	begin
	    set @SPVersionInfo = N''
	    if @clientVersion is not NULL
	    begin
	        if @clientVersion = N'9.0.0(BUILD84)'
	            set @SPVersionInfo = N'9.0 R2'
	        else
	            set @SPVersionInfo = @clientVersion
	    end
	end
	RETURN @SPVersionInfo
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientProductVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientProductVersion' AND revision = '1.3.68.1')

  insert into GXDBVersions values(5, 'scgGetClientProductVersion',  '1.3.68.1', 'scgGetClientProductVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
