

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientOnlineDays.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientOnlineDays'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientOnlineDays]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientOnlineDays]
  delete from GXDBVersions where name = 'scgGetClientOnlineDays' and type = 5
END
GO

	CREATE FUNCTION scgGetClientOnlineDays(@clientId integer)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @daysOnline INTEGER =
	ISNULL((SELECT MAX(CTC.lastOnlineTime)
		    FROM   CCRClientToClient CTC WITH(NOLOCK)
            WHERE      CTC.FromClientId = 2 AND CTC.ToClientId = @clientId
				   AND CTC.serviceType=0 AND CTC.lastOfflineTime < CTC.lastOnlineTime), 0)
			IF @daysOnline > 0
				SET @daysOnline = (dbo.GetUnixTime(GetUTCDate()) - @daysOnline)/(24*3600)
			RETURN @daysOnline
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientOnlineDays]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientOnlineDays' AND revision = '')

  insert into GXDBVersions values(5, 'scgGetClientOnlineDays',  '', 'scgGetClientOnlineDays', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
