

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientOfflineDays.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientOfflineDays'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientOfflineDays]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientOfflineDays]
  delete from GXDBVersions where name = 'scgGetClientOfflineDays' and type = 5
END
GO

	CREATE FUNCTION scgGetClientOfflineDays(@clientId integer)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @DaysOffline INTEGER =
		ISNULL((SELECT MAX(CTC.lastOfflineTime)
				 FROM CCRClientToClient CTC WITH(NOLOCK)
				 WHERE CTC.FromClientId = 2 AND CTC.ToClientId = @clientId
					   AND CTC.serviceType=0 AND CTC.lastOfflineTime > CTC.lastOnlineTime), 0)
		IF @DaysOffline > 0
			SET @DaysOffline = (dbo.GetUnixTime(GetUTCDate()) - @DaysOffline)/(24*3600)
		RETURN @DaysOffline
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientOfflineDays]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientOfflineDays' AND revision = '1.3.80.1')

  insert into GXDBVersions values(5, 'scgGetClientOfflineDays',  '1.3.80.1', 'scgGetClientOfflineDays', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
