

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientOSVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientOSVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientOSVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientOSVersion]
  delete from GXDBVersions where name = 'scgGetClientOSVersion' and type = 5
END
GO

	CREATE FUNCTION scgGetClientOSVersion(@i_clientId integer)
	RETURNS NVARCHAR(max)
	-- WITH ENCRYPTION
	AS
	BEGIN
	declare @simOsInfo nvarchar(2048)
	declare @osName nvarchar(255)
	declare @osRel nvarchar(255)
	declare @osInfo nvarchar(1024)
	declare @isNas int = 0
	declare @osId int = 0
	declare @clientStatus int = 0
	declare @simOSId int = 0
	set @simOsInfo = (select attrval from APP_ClientProp with (nolock) where attrName like 'sim os info' and componentNameId = @i_clientId)
    SET @osName = dbo.GetClientOSName(@i_clientId, @simOsInfo)
	select @clientStatus = status, @simOSId = simOperatingSystemId from APP_Client with (nolock) where id = @i_clientId
	if @osName is NULL or @osName = ''
	    set @osName = (select name from simOperatingSystem with (nolock) where id = @simOSId)
	set @isNas = (select (case Type
	                when 'Any' then (case SubType
	                                    when 'NAS' then 1
	                                    else 0
	                                    end)
	else 0
	                end)
	                from simOperatingSystem with (nolock) where id = @simOSId)
	if @isNas <> 0 and @clientStatus & 2 != 2
	begin
	      if @clientStatus & 0x8000000 = 0
	      begin
	          set @osInfo = ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo with (nolock) where ClientId = @i_clientId),'')
	          if @osInfo <> ''
	                set @osName = @osName + N' ' + @osInfo
	          end
	      else
	            set @osName = ''
	end
	RETURN @osName
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientOSVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientOSVersion' AND revision = '1.3.68.2')

  insert into GXDBVersions values(5, 'scgGetClientOSVersion',  '1.3.68.2', 'scgGetClientOSVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
