

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgDaysSinceLastBkpForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgDaysSinceLastBkpForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgDaysSinceLastBkpForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgDaysSinceLastBkpForClient]
  delete from GXDBVersions where name = 'scgDaysSinceLastBkpForClient' and type = 5
END
GO

	CREATE FUNCTION scgDaysSinceLastBkpForClient(@clientId integer)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
	    -- job status constants declare in /vaultcx/Source/Include/JobManager/cvjob.h
	    DECLARE @statusSuccess INT = 1          -- JMSUCCESS
	    DECLARE @statusPartialSuccess INT = 3   -- PARTIALSUCCESS
	    DECLARE @lastBackupForClient INTEGER = ISNULL(
	        (SELECT  MAX(servStartDate)
	         FROM    JMBkpStats BS WITH(NOLOCK) INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = BS.appId
	         WHERE       APP.clientId = @clientId
	                 AND BS.status IN (@statusSuccess, @statusPartialSuccess)), 0)
	    RETURN CASE WHEN @lastBackupForClient = 0 THEN 2147483647
	                ELSE (dbo.GetUnixTime(GetUTCDate()) - @lastBackupForClient)/(24*3600)
	           END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgDaysSinceLastBkpForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgDaysSinceLastBkpForClient' AND revision = '1.2.12.1')

  insert into GXDBVersions values(5, 'scgDaysSinceLastBkpForClient',  '1.2.12.1', 'scgDaysSinceLastBkpForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
