

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgDaysSinceClientCreated.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgDaysSinceClientCreated'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgDaysSinceClientCreated]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgDaysSinceClientCreated]
  delete from GXDBVersions where name = 'scgDaysSinceClientCreated' and type = 5
END
GO

	CREATE FUNCTION scgDaysSinceClientCreated(@clientId integer)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
	    -- refTime gets populated on client creation
	    DECLARE @clientCreatedDate INTEGER = ISNULL((SELECT refTime FROM APP_Client WHERE id = @clientId), 0)
	    -- in some cases (for example, for CS itself) refTime is not set. Then try to figure out when the very first package was installed
	    -- for the client
	    IF @clientCreatedDate = 0 BEGIN
	        SET @clientCreatedDate  = dbo.GetUnixTime((SELECT Min(OpTime) FROM simInstalledPackagesHistory WHERE ClientId = @clientId))
	    END
	    -- return number of days since then
	    RETURN CASE WHEN @clientCreatedDate = 0 THEN 2147483647
	                ELSE (dbo.GetUnixTime(GetUTCDate()) - @clientCreatedDate)/(24*3600)
	           END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgDaysSinceClientCreated]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgDaysSinceClientCreated' AND revision = '1.2.12.1')

  insert into GXDBVersions values(5, 'scgDaysSinceClientCreated',  '1.2.12.1', 'scgDaysSinceClientCreated', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
