

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgCompareAppTypes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgCompareAppTypes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgCompareAppTypes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgCompareAppTypes]
  delete from GXDBVersions where name = 'scgCompareAppTypes' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION scgCompareAppTypes(@clientId integer, @operation varchar(8), @Agents XML)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @AppTypes TABLE (
			appTypeId INT PRIMARY KEY
		)
		INSERT INTO @AppTypes
			SELECT ref.value('@appTypeId' , 'INT') appTypeId FROM @Agents.nodes('TMMsg_AppGroupSelection/appTypes') R(ref)
			UNION --ALL
			SELECT
				at.appTypeId
			FROM APP_AppTypeGroupAssoc at WITH(NOLOCK)
				INNER JOIN (SELECT ref.value('@appGroupId' , 'INT') appGroupId FROM @Agents.nodes('TMMsg_AppGroupSelection/appGroups') R(ref)) ag ON
					at.appGroupId = ag.appGroupId
					AND at.typeOfGroup = 0

		DECLARE @return_status INTEGER = 0
		SELECT TOP 1
			@return_status = 1
		FROM
			@AppTypes at
			INNER JOIN APP_IDAName n ON
				n.clientId = @clientId
				AND at.appTypeId = n.appTypeId

		--SELECT @return_status return_status

		DECLARE @result INT = 0
		SELECT
			@result = 1
		WHERE
			((@return_status = 1) AND (@operation = '='))
			OR
			((@return_status != 1) AND (@operation = '!='))

		RETURN @result
	END
	GO
	SET QUOTED_IDENTIFIER ON
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgCompareAppTypes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgCompareAppTypes' AND revision = '1.8.44.2')

  insert into GXDBVersions values(5, 'scgCompareAppTypes',  '1.8.44.2', 'scgCompareAppTypes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
