

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgClientUsesStoragePolicy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgClientUsesStoragePolicy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgClientUsesStoragePolicy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgClientUsesStoragePolicy]
  delete from GXDBVersions where name = 'scgClientUsesStoragePolicy' and type = 5
END
GO

	CREATE FUNCTION scgClientUsesStoragePolicy(@clientid INTEGER, @operation NVARCHAR(10), @groupPattern NVARCHAR(1024))
	RETURNS INTEGER
	-- WITH ENCRYPTION
	BEGIN

    DECLARE @rv INTEGER = 0

    IF @operation = 'E_WITH'                        BEGIN SET @groupPattern = '%' + @groupPattern END
    IF @operation = 'S_WITH'                        BEGIN SET @groupPattern = @groupPattern + '%' END
    IF @operation = 'LIKE' OR @operation = 'N_LIKE' BEGIN SET @groupPattern = '%' + @groupPattern + '%' END

	DECLARE @spList TABLE (id integer)
	INSERT INTO @spList
		SELECT id FROM archGroup WHERE name LIKE @groupPattern

		SET @rv = CASE WHEN
						EXISTS( --data SP of all valid subclients
                                --data SP for all subclient policy subclient
                                SELECT	APP.clientId
							    FROM		APP_Application APP WITH (NOLOCK)
							    WHERE		APP.clientId = @clientId
										AND APP.appTypeId NOT IN (84, 107)
                                        AND (APP.appTypeId < 600 OR APP.appTypeId = 1030)
                                        AND APP.subclientStatus & 4 <> 4  AND APP.subclientStatus & 16 <> 16  AND APP.subclientStatus & 32 <> 32
										AND APP.dataArchGrpID IN (SELECT id FROM @spList))


						OR EXISTS( --log SP for all valid SQL subclients
                                SELECT APP.clientId
							    FROM	 APP_Application APP WITH (NOLOCK)
							    WHERE	     APP.clientId = @clientId
                                         AND APP.appTypeId IN (81)
                                         AND APP.subclientStatus & 4 <> 4  AND APP.subclientStatus & 16 <> 16 AND  APP.subclientStatus & 32 <> 32
										 AND APP.logArchGrpID IN (SELECT id FROM @spList) )

                        OR EXISTS( --log SP for all instances of oracle, mysql, SAP, db2,postgre,RAC,sapmaxDB,db2 ,informix
                                SELECT	APP.clientId
                                FROM		APP_InstanceName INST WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
                                WHERE		APP.clientId		= @clientId
                                        AND APP.appTypeId IN (22,104,61,37,79,125,80,62,103,3,135)
                                        AND APP.subclientStatus & 8 = 8
                                        AND INST.id		= APP.instance
                                        AND INST.status & 16 <> 16
                                        AND APP.logArchGrpID IN (SELECT id FROM @spList))

						OR EXISTS(  --log SP for all backupsets of db2
                                SELECT APP.clientId
							    FROM		APP_BackupsetName BS WITH (NOLOCK), APP_InstanceName INST WITH (NOLOCK), APP_Application APP WITH (NOLOCK)
							    WHERE		APP.clientId = @clientId
                                        AND APP.appTypeId IN (37,62,103)
                                        AND INST.id		= APP.instance
                                        AND INST.status & 16 <> 16
                                        AND BS.id		= APP.backupset
                                        AND BS.status & 16 <> 16
                                        AND APP.subclientStatus & 8 = 8
                                        AND APP.logArchGrpID IN (SELECT id FROM @spList) )


			  THEN 1 ELSE 0 END

        IF (@operation = '!=' OR @operation = 'N_LIKE') BEGIN
            IF @rv = 0 BEGIN SET @rv = 1 END
            ELSE       BEGIN SET @rv = 0 END
        END

	    RETURN @rv

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgClientUsesStoragePolicy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgClientUsesStoragePolicy' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'scgClientUsesStoragePolicy',  '1.1.2.3', 'scgClientUsesStoragePolicy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
