

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgCheckPackageInstalled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgCheckPackageInstalled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgCheckPackageInstalled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgCheckPackageInstalled]
  delete from GXDBVersions where name = 'scgCheckPackageInstalled' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgCheckPackageInstalled(@clientId integer, @operation varchar(8), @packagesXml XML)
RETURNS INTEGER
-- WITH ENCRYPTION
AS
BEGIN
	DECLARE @package_exists INTEGER = 0
	DECLARE @packages TABLE (package INTEGER)
	INSERT INTO @packages(package)
		SELECT ref.value('@val' , 'integer')
		FROM @packagesXml.nodes('App_AdvanceKeyInfo/packages') R(ref)
	-- Direct association with packageIds inputted
	IF EXISTS ( (select package from @packages) INTERSECT (SELECT simPackageID FROM simInstalledPackages with(nolock) where clientId=@clientId))
		SET @package_exists = 1
	IF (@package_exists = 0)
	BEGIN
		-- Check if associated to group of packages under the same Display Name Grouping
		-- Correction change name to DisplayName column to get all packages grouped under the same display name, since name is unique to a given package
		IF EXISTS ((select DisplayName from simpackage with(nolock) where id in (select package from @packages)) INTERSECT (SELECT DisplayName FROM simpackage with(nolock) where id in (select simPackageid from simInstalledPackages with(nolock) where ClientId=@clientId)))
			SET @package_exists = 1
	END
	DECLARE @result INTEGER = 0
	IF ((@operation = '=') AND (@package_exists= 1))
			SET @result=1
	IF ((@operation = '!=') AND (@package_exists != 1))
			SET @result=1
	return @result
END
GO
SET QUOTED_IDENTIFIER ON
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgCheckPackageInstalled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgCheckPackageInstalled' AND revision = '')

  insert into GXDBVersions values(5, 'scgCheckPackageInstalled',  '', 'scgCheckPackageInstalled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
