

--  ------------  Generated from [../../../Source/CommServer/Db/Function/rptGetMediaListByCopyOrJobFn.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: rptGetMediaListByCopyOrJobFn'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[rptGetMediaListByCopyOrJobFn]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[rptGetMediaListByCopyOrJobFn]
  delete from GXDBVersions where name = 'rptGetMediaListByCopyOrJobFn' and type = 5
END
GO

	CREATE FUNCTION rptGetMediaListByCopyOrJobFn(@copyId	INTEGER, @jobId INTEGER)
	RETURNS NVARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @tempAFCopy TABLE(
			afId	integer,
			ccId	integer
		)

		IF @copyId > 0
			INSERT INTO @tempAFCopy
			SELECT archFileId, commCellId
			FROM   archFileCopy WITH (READUNCOMMITTED)
			WHERE  archCopyId = @copyId AND isValid = 1
		ELSE
			INSERT INTO @tempAFCopy
			SELECT id, commCellId
			FROM   archFile WITH (READUNCOMMITTED)
			WHERE  JobId =  @jobId
		DECLARE @tempChunk TABLE (archChunkId INTEGER, ccId INTEGER)
		DECLARE @tempVolume TABLE (volumeId INTEGER)

		INSERT INTO @tempChunk
		SELECT DISTINCT archChunkId, ccid
		FROM   archChunkMapping WITH (READUNCOMMITTED), @tempAFCopy
		WHERE  archFileId = afId AND commCellId = ccId AND (@copyId > 0 AND archCopyId = @copyId OR @copyId = 0)

		INSERT INTO   @tempVolume
		SELECT DISTINCT volumeId
		FROM   archChunk WITH (READUNCOMMITTED), @tempChunk
		WHERE  id = archChunkId and commCellId = ccId

		DECLARE @tempMedia TABLE (barcode VARCHAR(64), magMediaSideId INTEGER)

		INSERT INTO @tempMedia
		SELECT DISTINCT M.barcode, magMediaSideId=(case M.MediaTypeId when 10001 /*CV_MAGNETIC_MEDIA*/ then V.MediaSideId else 0 end)
		FROM @tempVolume T 	LEFT JOIN MMVolume V WITH (READUNCOMMITTED) ON T.VolumeId=V.VolumeId
					LEFT JOIN MMMedia M WITH (READUNCOMMITTED) ON V.MediaId=M.MediaId

		DECLARE @media VARCHAR(MAX)
		SET @media = ''
		DECLARE magCur CURSOR FOR
				SELECT magMediaSideId, barcode,
					mountPath=M.MountPathName
				FROM @tempMedia LEFT OUTER JOIN CommServ.dbo.MMS2getMountPathNameGUIView M WITH (READUNCOMMITTED)
					ON magMediaSideId>0 and magMediaSideId=M.MediaSideId
					ORDER BY barcode, mountPath
		OPEN magCur
		DECLARE @isMag INT
		DECLARE @barcode VARCHAR(128)
		DECLARE @mountPath	VARCHAR(256)
		FETCH NEXT FROM magCur INTO @isMag, @barcode, @mountPath
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @media = '\n' + @media + (CASE WHEN @isMag > 0 THEN @mountPath ELSE @barcode END)
			FETCH NEXT FROM magCur INTO @isMag, @barcode, @mountPath
		END
		CLOSE magCur
		DEALLOCATE magCur
		RETURN @media
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [rptGetMediaListByCopyOrJobFn]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'rptGetMediaListByCopyOrJobFn' AND revision = '1.1.208.1')

  insert into GXDBVersions values(5, 'rptGetMediaListByCopyOrJobFn',  '1.1.208.1', 'rptGetMediaListByCopyOrJobFn', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
