

--  ------------  Generated from [../../../Source/CommServer/Db/Function/patchGetCacheInfoByLevel.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: patchGetCacheInfoByLevel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[patchGetCacheInfoByLevel]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[patchGetCacheInfoByLevel]
  delete from GXDBVersions where name = 'patchGetCacheInfoByLevel' and type = 5
END
GO

CREATE FUNCTION patchGetCacheInfoByLevel(@inClientId integer, @inReleaseID integer, @inSPVersionID integer, @inOSType integer, @inCacheLevel integer=0)
RETURNS @cacheInfo table
(
	UpdateAgentId	integer,
	Release		integer,
	OSType		integer,
	HighestSP	varchar(100),
	IsSPValid	integer,
	AddUpdates	varchar(max),
	TransactionId	integer,
	RevisionId	integer,
	UpdatePackNumber integer,
	UpdatePackFriendlyName	varchar(64),
	CacheID		integer,
	UPID integer
)
AS
BEGIN
DECLARE @cacheID INT = -1
DECLARE @updatePackNumber INT = -1
SELECT  @cacheID = cacheID, @updatePackNumber = updatePackNumber
FROM patchGetCacheIDsByLevel(@inClientId, @inReleaseID, @inSPVersionID, @inOSType, @inCacheLevel)
INSERT INTO @cacheInfo
	SELECT TOP 1 pmc.ClientId,
			pmc.ReleaseId,
			pmc.OSId,
			pmc.HighestSP,
			pmc.IsSPValid,
			(CASE WHEN @updatePackNumber = 0 THEN pmc.AddUpdates ELSE '' END),
			spver.TransactionId,
			spver.RevisionId,
			@updatePackNumber,
			CASE WHEN @updatePackNumber = 0 THEN '' ELSE COALESCE(pup.FriendlyName, '') END,
			pmc.id,
			COALESCE(pup.UPVersionID, 0)
	FROM PatchMultiCache pmc WITH(NOLOCK)
	JOIN PatchSPVersion spver WITH(NOLOCK) ON pmc.SPVersionId = spver.id
	LEFT JOIN PatchCacheUpdatePackMap pcup WITH(NOLOCK) ON pmc.id = pcup.CacheID
	LEFT JOIN PatchUPVersion pup WITH(NOLOCK) ON pcup.UpdatePackID = pup.UPVersionID
	WHERE 	pmc.id = @cacheID
	ORDER BY spver.TransactionId DESC, pup.MaxTransactionID DESC
IF @updatePackNumber > 0
	UPDATE @cacheInfo
	SET AddUpdates = (
		SELECT LEFT (PatchIds, LEN(PatchIds) - 1)
		FROM (
			SELECT DISTINCT REVERSE(SUBSTRING(REVERSE(pini.PatchName), 0, CHARINDEX('_', REVERSE(pini.PatchName)))) + ','
			FROM PatchUpdatePackPatchesMap puppm WITH(NOLOCK)
				JOIN PatchINI pini WITH(NOLOCK) ON puppm.UpdateID = pini.id
			WHERE puppm.UpdatePackID = UPID AND bIsAdditionalUpdate = 1 AND pini.OSId = OSType
			FOR XML PATH ('')
		) c (PatchIds)
	)
RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [patchGetCacheInfoByLevel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'patchGetCacheInfoByLevel' AND revision = '1.1.2.12')

  insert into GXDBVersions values(5, 'patchGetCacheInfoByLevel',  '1.1.2.12', 'patchGetCacheInfoByLevel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
