

--  ------------  Generated from [../../../Source/CommServer/Db/Function/patchGetCacheIDsByLevel.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: patchGetCacheIDsByLevel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[patchGetCacheIDsByLevel]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[patchGetCacheIDsByLevel]
  delete from GXDBVersions where name = 'patchGetCacheIDsByLevel' and type = 5
END
GO

CREATE FUNCTION patchGetCacheIDsByLevel(@inClientId integer, @inReleaseID integer, @inSPVersionID integer, @inOSType integer, @inCacheLevel integer=0)
RETURNS @cacheIDs table
(
	cacheID INT,
	updatePackNumber INT
)
AS
BEGIN
DECLARE @csActivePhysicalNode INT = 2
IF EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentnameid = 2 AND attrname = 'Virtual Client' and attrval = 1)
BEGIN
	SELECT @csActivePhysicalNode = acp.attrval
	FROM app_clientprop acp WITH(NOLOCK)
	WHERE acp.componentnameid = 2 AND acp.attrname = 'CS Active Physical Node'
END
DECLARE @csSPVersionID INT = NULL
DECLARE @csUpdatePackNumber INT = 0
SELECT @csSPVersionID = psp.id, @csUpdatePackNumber = sip.UPNumber
FROM simInstalledPackages sip WITH(NOLOCK)
JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.spversionID = psp.id
WHERE sip.clientid = @csActivePhysicalNode AND (sip.simpackageid = 20 OR sip.simpackageid = 1020)
DECLARE @cacheID INT = NULL
DECLARE @updatePackNumber INT = NULL
-- GET MEDIA SIDE
IF @inSPVersionID > 0
BEGIN
	-- GET CLEINT SIDE
	DECLARE @transactionID INT = ISNULL((SELECT transactionID FROM PatchSPVersion NOLOCK WHERE id = @inSPVersionID),0)
	IF @transactionID > 0
		SELECT TOP 1 @cacheID = pmc.id, @updatePackNumber = COALESCE(upVer.UPNumber, 0)
		FROM PatchMultiCache pmc WITH(NOLOCK)
			JOIN PatchSPVersion spver WITH(NOLOCK) ON pmc.SPVersionId = spver.id
			LEFT JOIN PatchCacheUpdatePackMap pcupMap WITH(NOLOCK) ON pmc.id = pcupMap.CacheID
			LEFT JOIN PatchUPVersion upVer WITH(NOLOCK) ON pcupMap.UpdatePackID = upVer.UPVersionID
		WHERE 	pmc.ClientId = @inClientId AND pmc.ReleaseId=@inReleaseID AND pmc.OSId=@inOSType AND spver.transactionID = @transactionID
		ORDER BY spver.SPMajor DESC, spver.SPMinor DESC, spVer.TransactionID DESC, spVer.RevisionId DESC, COALESCE(upVer.UPNumber, 0) DESC
END
ELSE
SELECT TOP 1
		@cacheID = pmc.id,
		@updatePackNumber = COALESCE(upVer.UPNumber, 0)
FROM PatchMultiCache pmc WITH(NOLOCK)
JOIN PatchSPVersion spver WITH(NOLOCK) ON pmc.SPVersionId = spver.id
JOIN PatchSPVersion csVer WITH(NOLOCK) ON @csSPVersionID = csVer.id
LEFT JOIN PatchCacheUpdatePackMap pcupMap WITH(NOLOCK) ON pmc.id = pcupMap.CacheID
LEFT JOIN PatchUPVersion upVer WITH(NOLOCK) ON pcupMap.UpdatePackID = upVer.UPVersionID
WHERE 	pmc.ReleaseId=@inReleaseID AND
		pmc.OSId=@inOSType AND
		pmc.ClientId=@inClientId AND
		(
			@inReleaseID < csVer.Release
			OR
@inCacheLevel = 0 AND
			(
				(
					dbo.CompareServicePackLevel(spver.SPMajor, spver.SPMinor, spver.TransactionID, csVer.SPMajor, csVer.SPMinor, csVer.TransactionId) <= 0
				)
			)
			OR
@inCacheLevel = 1 AND
			(
				(
					dbo.CompareServicePackLevel(spver.SPMajor, spver.SPMinor, spver.TransactionID, csVer.SPMajor, csVer.SPMinor, csVer.TransactionId) > 0
				)
			)
		)
ORDER BY spver.SPMajor DESC, spver.SPMinor DESC, spVer.TransactionID DESC, spVer.RevisionId DESC, COALESCE(upVer.UPNumber, 0) DESC
INSERT INTO @cacheIDs VALUES(@cacheID, @updatePackNumber)
RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [patchGetCacheIDsByLevel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'patchGetCacheIDsByLevel' AND revision = '1.1.4.8')

  insert into GXDBVersions values(5, 'patchGetCacheIDsByLevel',  '1.1.4.8', 'patchGetCacheIDsByLevel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
