

--  ------------  Generated from [../../../Source/CommServer/Db/Function/parseDB2PartitionClientIdString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: parseDB2PartitionClientIdString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[parseDB2PartitionClientIdString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[parseDB2PartitionClientIdString]
  delete from GXDBVersions where name = 'parseDB2PartitionClientIdString' and type = 5
END
GO

	CREATE FUNCTION parseDB2PartitionClientIdString(@partitionString NVARCHAR(MAX) )
	RETURNS @DB2PartitionClientIds TABLE (PartitionId INT , clientId INT)
	AS
	BEGIN
		DECLARE @inStrLen int
		DECLARE @partitionId int
		DECLARE @clientId int
		DECLARE @nextSeper int
		DECLARE @nextComma int

		DECLARE @element nvarchar(64)
		DECLARE @partitionIdStr nvarchar(64)
		DECLARE @clientIdStr nvarchar(64)

		SET  @inStrLen   = LEN(@partitionString)
		IF @inStrLen > 0
		BEGIN
			WHILE LEN(@partitionString) > 0
			BEGIN
				SET @nextSeper   = CHARINDEX(' ', @partitionString, 1)
				IF @nextSeper = 0
				BEGIN
					SET @partitionString = @partitionString+' '
					SET @nextSeper = @instrlen+1
				END

				SET @element    = RTRIM(LTRIM(SUBSTRING(@partitionString, 1, @nextSeper-1)))
				IF LEN(@element) > 0
				BEGIN
					SET @nextComma   = CHARINDEX(',', @partitionString, 1)
					IF @nextComma = 0
						BREAK

					SET @partitionIdStr    = RTRIM(LTRIM(SUBSTRING(@element, 1, @nextComma-1)))
					SET @clientIdStr    = RTRIM(LTRIM(SUBSTRING(@element, @nextComma+1, LEN(@element))))

					SET @partitionId = convert(int, @partitionIdStr)
					SET @clientId = convert(int, @clientIdStr)

					INSERT INTO @DB2PartitionClientIds VALUES(@partitionId, @clientId)
				END


				IF (@inStrLen - @nextSeper <= 0)
					BREAK

				SET @partitionString = SUBSTRING(@partitionString, @nextSeper+1, @inStrLen-@nextSeper)
				SET @inStrLen = LEN(@partitionString)

			END
		END

	   RETURN
	END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [parseDB2PartitionClientIdString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'parseDB2PartitionClientIdString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'parseDB2PartitionClientIdString',  '1.1', 'parseDB2PartitionClientIdString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
