

--  ------------  Generated from [../../../Source/CommServer/Db/Function/isVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isVisible]
  delete from GXDBVersions where name = 'isVisible' and type = 5
END
GO

	CREATE FUNCTION isVisible(@inUserid int, @inJobid int, @inCommcellid INT, @inClientid INT, @eventUserId INT, @libraryId INT = 0, @maClientId INT = 0, @mediaId INT = 0, @driveId INT = 0)
	RETURNS INT
	AS
	BEGIN

	IF @inUserId = 0 OR @eventUserId = @inUserId
	BEGIN
		-- no need to check visiblity
		RETURN 1
	END

	IF @inJobid <> 0 -- check the visibility of the job if the job id is passed in
	BEGIN
		DECLARE @isJobRunning		INT
		DECLARE @jobCategory		INT
		DECLARE @jobStartedBy		INT
		DECLARE @jobStartedByUser	varchar(255)

		DECLARE @srcClientid	INT
		DECLARE @destClientid	INT
		DECLARE @apptypeid		INT
		DECLARE @instanceid		INT
		DECLARE @backupsetid	INT
		DECLARE @subclientid	INT
		DECLARE @archGroupid	INT
		DECLARE @opType			INT
		DECLARE @userName		varchar(255)

		-- check if the job is running or completed so that the appropriate table can be checked
		SELECT @jobCategory = JMJobStats.jobCategory, @isJobRunning = CASE status WHEN 1 THEN 1 ELSE 0 END FROM JMJobStats WHERE jobid = @inJobid AND commcellid = @inCommcellId
		IF @isJobRunning IS NULL
		BEGIN
			-- the job id was not found. So return false
			RETURN 0
		END
		ELSE IF @isJobRunning = 1
		BEGIN
			-- this is a running job.
			IF @jobCategory = 1 -- this is a running backup job
			BEGIN
				SELECT @jobStartedBy = userid, @srcClientid = clientid, @apptypeid = apptypeid, @instanceid = instance, @backupsetid = backupset, @subclientid = applicationid FROM RunningBackups WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error.
					RETURN 0
				END
				ELSE
				BEGIN
					-- at least one of the capabilities are needed to see a backup job
					IF @jobStartedBy = @inUserid OR dbo.isBkpJobVisible(@inUserid,@inCommcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
			ELSE IF @jobCategory = 2 -- this is a running restore job
			BEGIN
				SELECT @jobStartedBy = userid, @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetId FROM RunningRestores WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error.
					RETURN 0
				END
				ELSE
				BEGIN
					-- at least one of the capabilities are needed to see a restore job
					-- the user can have rights on either the source or the destination client id
					IF @jobStartedBy = @inUserId OR dbo.isRstJobVisible(@inUserId,@inCommcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
			ELSE -- this is a running admin job
			BEGIN
				SELECT @jobStartedBy = userid, @archGroupid = archGrpId, @opType = opType FROM RunningAdminJobs WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error.
					RETURN 0
				END
				ELSE
				BEGIN
					IF @jobStartedBy = @inUserId OR dbo.isAdminJobVisible(@inUserId,@inCommcellId,@archGroupid,@inJobid,@opType,0)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
		END
		ELSE
		BEGIN
			-- this is a completed job.
			SET @userName = ISNULL((SELECT [login] FROM UMUsers WHERE id = @inUserId),'')

			IF @jobCategory = 1 -- this is a completed backup job
			BEGIN
				SELECT @jobStartedByUser = username, @srcClientid = App_Application.clientid, @apptypeid = App_Application.apptypeid, @instanceid = App_Application.instance, @backupsetid = App_Application.backupset, @subclientid = appId FROM JMBkpStats, App_Application WHERE jobid = @inJobid AND commcellId = @inCommcellId AND JMBkpStats.appId = App_Application.id
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error. However if the user id matches then return true for that USER
					RETURN 0
				END
				ELSE
				BEGIN
					-- at least one of the capabilities are needed to see a backup job
					IF @userName = @jobStartedByUser OR dbo.isBkpJobVisible(@inUserid,@inCommcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
			ELSE IF @jobCategory = 2 -- this is a completed restore job
			BEGIN
				SELECT @jobStartedByUser = username, @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetID FROM JMRestoreStats WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error.
					RETURN 0
				END
				ELSE
				BEGIN
					-- at least one of the capabilities are needed to see a restore job
					-- the user can have rights on either the source or the destination client id
					IF @userName = @jobStartedByUser OR dbo.isRstJobVisible(@inUserId,@inCommcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
			ELSE -- this is a completed admin job
			BEGIN
				SELECT @jobStartedByUser = username, @archGroupid = archGrpId, @opType = opType FROM JMAdminJobStatsTable WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- For admin jobs if the row cannot be found then ignore the user name and just check commcell level priveledges.
					IF dbo.isAdminJobVisible(@inUserId,@inCommcellId,0,@inJobid,@opType,0)=1
						RETURN 1
					ELSE
						RETURN 0
				END
				ELSE
				BEGIN
					IF @userName = @jobStartedByUser OR dbo.isAdminJobVisible(@inUserId,@inCommcellId,@archGroupid,@inJobid,@opType,0)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
		END
	END
	ELSE
	BEGIN
		IF @inClientId = 0
		BEGIN
			SET @inClientId = 2 -- current commcellid
		END

		-- now check for visibility of this client. If the user has any rights on this client then he can see events from this client
		IF dbo.isClientVisible(@inUserId,@inClientId,@libraryId,@maClientId,@mediaId,@driveId)=1
			RETURN 1
		ELSE
			RETURN 0
	END
	RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isVisible' AND revision = '1.5')

  insert into GXDBVersions values(5, 'isVisible',  '1.5', 'isVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
