

--  ------------  Generated from [../../../Source/CommServer/Db/Function/isSnapShotVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isSnapShotVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isSnapShotVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isSnapShotVisible]
  delete from GXDBVersions where name = 'isSnapShotVisible' and type = 5
END
GO

	CREATE FUNCTION isSnapshotVisible(@userid int, @copyId int, @arrayId int, @appId int)
	RETURNS INT
	AS
	BEGIN
		DECLARE @rowCount INT
		DECLARE @reqCapability INT

		DECLARE @archGroupId INT
		DECLARE @clientid INT
		DECLARE @apptypeid INT
		DECLARE @instanceid INT
		DECLARE @backupsetid INT

		SELECT @archGroupId=archGroupId FROM archGroupCopy WHERE id=@copyId
		SELECT @clientid=clientId, @apptypeid=appTypeId, @instanceid=instance , @backupsetid=backupSet FROM App_Application WHERE id=@appId

		-- capabilities required to view a backup job are one of the following: Job Management, Data Protection Operations, Browse and In Place Recover, Browse and Out of Place Recover, Browse, Report Management
		-- POWER(2,EV_SCHEDULE_ADMIN-1)
		IF @arrayId > 0 SET @reqCapability = POWER(2,1-1)
		-- POWER(2,EV_MANAGE_ARCHIVES-1)
		ELSE IF @copyId > 0 SET @reqCapability = POWER(2,4-1)
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1)
		ELSE IF @appId > 0 SET @reqCapability = POWER(2,16-1) | POWER(2,12-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,13-1)| POWER(2,15-1)
		-- need only one row that matches the required capability
		SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
		((clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0) OR
		(@archGroupId <> 0 AND (archGroupId=-10 OR @archGroupId = archGroupId)) OR
		(@arrayId <> 0 AND (arrayId=-10 OR @arrayId = arrayId)) OR
		(@clientId<>0 AND clientId=-10) OR
		(clientid=@clientid AND apptypeid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=@appId) OR
		(clientgroupid <> 0 AND EXISTS (SELECT TOP 1 * FROM APP_ClientGroupAssoc WHERE (UMUserCredentials.clientGroupId=-10 OR APP_ClientGroupAssoc.clientGroupId = UMUserCredentials.clientGroupId) AND APP_ClientGroupAssoc.clientid=@clientid))))
		RETURN ISNULL(@rowCount,0)
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isSnapShotVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isSnapShotVisible' AND revision = '1.4.2.1')

  insert into GXDBVersions values(5, 'isSnapShotVisible',  '1.4.2.1', 'isSnapShotVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
