

--  ------------  Generated from [../../../Source/CommServer/Db/Function/isJobStatusMatches.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isJobStatusMatches'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isJobStatusMatches]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isJobStatusMatches]
  delete from GXDBVersions where name = 'isJobStatusMatches' and type = 5
END
GO

 CREATE FUNCTION [isJobStatusMatches](@jobStatus INT, @statusCompleted INT, @statusCompletedErr INT, @statusCompletedWrn INT, @statusFailed INT, @statusKilled INT, @statusDelayed INT, @statusActive INT, @statusNoRun INT)
 RETURNS BIT
 AS
 BEGIN
    DECLARE @rv BIT = 1

    IF (@statusCompleted = 0) OR (@statusCompletedErr = 0) OR (@statusCompletedWrn = 0) OR (@statusFailed = 0) OR
       (@statusKilled = 0) OR (@statusDelayed = 0) OR (@statusActive = 0) OR (@statusNoRun = 0) BEGIN

        SET @rv = 0

        IF     @jobStatus = 7
            OR ((@statusCompleted    <> 0) AND (@jobStatus IN (1)))             -- JMSUCCESS
            OR ((@statusCompletedErr <> 0) AND (@jobStatus IN (3)))             -- PARTIALSUCCESS
            OR ((@statusCompletedWrn <> 0) AND (@jobStatus IN (14, 16)))            -- JMSUCCESSWITHWARNINGS
            OR ((@statusFailed       <> 0) AND (@jobStatus IN (2,15)))          -- FAIL, SYSTEMFAILED
            OR ((@statusKilled       <> 0) AND (@jobStatus IN (4)))             -- KILLED
            OR ((@statusDelayed      <> 0) AND (@jobStatus IN (5,6)))           -- STSTOPPED, STINTERRUPTED
            OR ((@statusActive       <> 0) AND (@jobStatus IN (10, 11, 12,13))) -- NOTATTEMPTED, CVJOBSTATUS_STARTED
            OR ((@statusNoRun        <> 0) AND (@jobStatus IN (8,9)))           -- STSKIPPED, DROPPED
        BEGIN
            SET @rv = 1
        END
    END

    RETURN @rv
  END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isJobStatusMatches]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isJobStatusMatches' AND revision = '1.3')

  insert into GXDBVersions values(5, 'isJobStatusMatches',  '1.3', 'isJobStatusMatches', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
