

--  ------------  Generated from [../../../Source/CommServer/Db/Function/isJobStateMatches.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isJobStateMatches'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isJobStateMatches]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isJobStateMatches]
  delete from GXDBVersions where name = 'isJobStateMatches' and type = 5
END
GO

 CREATE FUNCTION [dbo].[isJobStateMatches](@jobState INT, @stateCompleted INT, @stateCompletedErr INT, @stateCompletedWrn INT, @stateFailed INT, @stateKilled INT, @stateDelayed INT, @stateActive INT, @stateNoRun INT)
 RETURNS BIT
 AS
 BEGIN
     DECLARE @rv BIT = 1
     IF (@stateCompleted = 0) OR (@stateCompletedErr = 0) OR (@stateCompletedWrn = 0) OR (@stateFailed = 0) OR
        (@stateKilled = 0) OR (@stateDelayed = 0) OR (@stateActive = 0) OR (@stateNoRun = 0) BEGIN

         SET @rv = 0

         IF   ((@stateCompleted    <> 0) AND (@jobState IN (4, 9)))          -- COMPLETED, COMPLETEDSUCCESS                                 : COMPLETED
 		    OR((@stateCompletedErr <> 0) AND (@jobState IN (12)))            -- COMPLETEDPARTIAL                                             : COMPLETED_WITH_ERRORS
 		    OR((@stateCompletedWrn <> 0) AND (@jobState IN (19)))            -- COMPLETEDWITHWARNINGS                                        : COMPLETED_WITH_WARNINGS
            OR((@stateFailed       <> 0) AND (@jobState IN (10, 18)))        -- COMPLETEDFAIL, DANGLINGJOBCLEANUP                            : FAILED
		    OR((@stateKilled       <> 0) AND (@jobState IN (11 )))           -- STATEKILLED                                                  : KILLED
		    OR((@stateDelayed      <> 0) AND (@jobState IN (2,3,5,14,15,16)))-- PENDING, WAITING, STOPPED, DORMANTSCHEDWAIT, DORMANT, QUEUED : DELAYED
            OR((@stateActive       <> 0) AND (@jobState IN (1,6,7,8,13,17))) -- RUNNING, *PENDING, RUNNING_UNVERIFIABLE                      : RUNNING
         BEGIN
             SET @rv = 1
         END

     END

     RETURN @rv
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isJobStateMatches]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isJobStateMatches' AND revision = '1.2')

  insert into GXDBVersions values(5, 'isJobStateMatches',  '1.2', 'isJobStateMatches', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
