

--  ------------  Generated from [../../../Source/CommServer/Db/Function/isBkpJobVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isBkpJobVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isBkpJobVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isBkpJobVisible]
  delete from GXDBVersions where name = 'isBkpJobVisible' and type = 5
END
GO

	CREATE FUNCTION isBkpJobVisible(@userid int, @commcellid int, @clientid int, @apptypeid int, @instanceid int, @backupsetid int, @subclientid int)
	RETURNS INT
	AS
	BEGIN
		DECLARE @rowCount INT
		DECLARE @reqCapability INT
		-- capabilities required to view a backup job are one of the following: Job Management, Data Protection Operations, Browse and In Place Recover, Browse and Out of Place Recover, Browse, Report Management, View
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
		SET @reqCapability = POWER(2,16-1) | POWER(2,12-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,13-1) | POWER(2,15-1) | POWER(2,31-1)
		-- need only one row that matches the required capability
		SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WITH(NOLOCK) WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
		((clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0 ) OR
		(clientid=-10) OR
		(clientid=@clientid AND apptypeid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=@subclientid) OR
		(clientgroupid <> 0 AND EXISTS (SELECT TOP 1 * FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = UMUserCredentials.clientGroupId OR UMUserCredentials.clientGroupId=-10) AND APP_ClientGroupAssoc.clientid=@clientid))))
		RETURN ISNULL(@rowCount,0)
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isBkpJobVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isBkpJobVisible' AND revision = '1.14.2.2')

  insert into GXDBVersions values(5, 'isBkpJobVisible',  '1.14.2.2', 'isBkpJobVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
