

--  ------------  Generated from [../../../Source/CommServer/Db/Function/isBackupSetGuidExists.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isBackupSetGuidExists'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isBackupSetGuidExists]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isBackupSetGuidExists]
  delete from GXDBVersions where name = 'isBackupSetGuidExists' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION isBackupSetGuidExists(@i_dataSourceId INT, @i_backupSetGuid VARCHAR(36))
RETURNS INT
AS
BEGIN
	DECLARE @retVal INT =0
	DECLARE @l_backupsetguidXmlPropId INT  = ISNULL((SELECT PropertyId FROM SEProperty (NOLOCK)  WHERE PropertyName = 'backupsetguidxml'),0)
	-- temp table with XML column
	DECLARE  @tempPropertyValXML TABLE	( t_propXmlVal XML )
	--convert propertyValue from varchar to XML
	INSERT INTO @tempPropertyValXML
	SELECT PropertyValue
	FROM SEDataSourceProperty (NOLOCK)
	WHERE DataSourceId =  @i_dataSourceId AND PropertyId = @l_backupsetguidXmlPropId
	IF EXISTS (
			SELECT TOP 1 1
			FROM @tempPropertyValXML
			CROSS APPLY t_propXmlVal.nodes('backupSetGUID') as R1(ref1)
			WHERE ref1.value('@val', 'NVARCHAR(36)') = @i_backupSetGuid
		)
		SET @retVal = 1
	RETURN @retVal
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isBackupSetGuidExists]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isBackupSetGuidExists' AND revision = '')

  insert into GXDBVersions values(5, 'isBackupSetGuidExists',  '', 'isBackupSetGuidExists', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
