

--  ------------  Generated from [../../../Source/CommServer/Db/Function/isAdminJobVisible.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: isAdminJobVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isAdminJobVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isAdminJobVisible]
  delete from GXDBVersions where name = 'isAdminJobVisible' and type = 5
END
GO

	CREATE FUNCTION isAdminJobVisible(@userid int, @commcellid int, @archGroupId int, @jobid int, @optype int, @clientId  int = 0)
	RETURNS INT
	AS
	BEGIN
		DECLARE @rowCount INT
		DECLARE @reqCapability INT
		DECLARE @isLibraryOperation INT
		DECLARE @workflowId INT
		DECLARE @appID INT
		-- CASE_MGR_INDEX_COPY, CASE_MGR_INDEX_DELETE, SUBCLIENTCONTENTINDEX, DATA_ANALYTICS2, ONLINE_CRAWL, CLOUD_ANALYTICS
		IF @optype IN (134, 139, 113, 112, 130, 153)
		BEGIN
			SELECT @appID = appID FROM JMAdminJobInfoTable WITH(NOLOCK) WHERE jobId = @jobId AND commCellId = @commcellId
			IF  @appID IS NULL
				SELECT @appID = appID FROM JMAdminJobStatsTable WITH(NOLOCK) WHERE jobId = @jobId AND commCellId = @commcellId
		END
		IF @optype = 90
		BEGIN
			SELECT @workflowId = workFlowId FROM JMAdminJobInfoTable WITH(NOLOCK) WHERE jobId = @jobId AND commCellId = @commcellId
			IF @workflowId IS NULL
				SELECT @workflowId = workFlowId FROM JMAdminJobStatsTable WITH(NOLOCK) WHERE jobId = @jobId AND commCellId = @commcellId
		END
		-- If subclient based job, just check for backup rights
		IF @appID > 0
		BEGIN
			SET @rowCount = (SELECT dbo.isBkpJobVisible(@userid, @commcellid, clientId, appTypeId, instance, backupSet, @appID) FROM APP_Application WITH(NOLOCK) WHERE id = @appID)
		END
		ELSE
		BEGIN
			-- MEDIAINVENTORY, TAPEERASE, DRIVEVALIDATION, DRIVECLEANING, STAMPMEDIA, CATALOGUEMEDIA
			IF @optype IN (21,32,41,42,46,47)
			BEGIN
				SET @isLibraryOperation = 1
				-- capabilities required to view an admin job are one of the following: Job Management, Administrative Management, Storage Policy Management, View
				-- POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
				SET @reqCapability = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
			END
			ELSE
			BEGIN
				SET @isLibraryOperation = 0
				-- capabilities required to view an admin job are one of the following: Job Management, Administrative Management, Storage Policy Management, View
				-- POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_VISIBILITY-1)
				SET @reqCapability = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,31-1)
			END
			SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WITH(NOLOCK) WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
			((clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0) OR
			(@archGroupId <> 0 AND (@archGroupId = archGroupId OR archGroupId=-10)) OR
			(@workflowId>0 AND (workflowId=@workflowId OR workflowId=-10)) OR
			(@clientId>0 AND (@clientId = clientid OR clientId=-10) AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0)OR
			(@clientId>0 AND clientgroupId <> 0 AND EXISTS (SELECT TOP 1 * FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = UMUserCredentials.clientGroupId OR UMUserCredentials.clientGroupId=-10) AND APP_ClientGroupAssoc.clientid=@clientid))))
			IF ISNULL(@rowCount,0) = 0
			BEGIN
				IF @isLibraryOperation = 1
				BEGIN
					SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WITH(NOLOCK) WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
					(libraryId =-10 OR libraryId IN (SELECT attributeValueInt FROM JMJobOptions WITH(NOLOCK) WHERE jobId = @jobId AND commCellId = @commcellId AND attributeId = 10)))
				END
			END
		END
		RETURN ISNULL(@rowCount,0)
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isAdminJobVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isAdminJobVisible' AND revision = '1.13.2.7')

  insert into GXDBVersions values(5, 'isAdminJobVisible',  '1.13.2.7', 'isAdminJobVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
