

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSubclientAttrName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSubclientAttrName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSubclientAttrName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSubclientAttrName]
  delete from GXDBVersions where name = 'GetSubclientAttrName' and type = 5
END
GO

	CREATE FUNCTION GetSubclientAttrName(@propName NVARCHAR(1024), @refCopyId INTEGER)
	RETURNS NVARCHAR(1024)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @attrName nvarchar(255)
		--Supported Attributes
		DECLARE @supportedAttributes table(propertyName nvarchar(1024))
		--sys:full cycle num , sys:last full, sys:last incr, sys:last full start with SP Change, Reason last backup time cleared
		INSERT INTO @supportedAttributes values('sys:full cycle num')
		INSERT INTO @supportedAttributes values('sys:non full cycle num')
		INSERT INTO @supportedAttributes values('sys:last full')
		INSERT INTO @supportedAttributes values('sys:last incr')
		INSERT INTO @supportedAttributes values('sys:last full start with SP Change')
		INSERT INTO @supportedAttributes values('Reason last backup time cleared')
		BEGIN
			IF @refCopyId <> 0 AND EXISTS(SELECT *FROM @supportedAttributes where propertyName = @propName)
				select @attrName = @propName + '_' +cast(@refCopyId as nvarchar(10))
			ELSE
				select @attrName = @propName
		END
		RETURN @attrName
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSubclientAttrName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSubclientAttrName' AND revision = '1.3.208.1')

  insert into GXDBVersions values(5, 'GetSubclientAttrName',  '1.3.208.1', 'GetSubclientAttrName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
