

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getSIDBStoreNameList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getSIDBStoreNameList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getSIDBStoreNameList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getSIDBStoreNameList]
  delete from GXDBVersions where name = 'getSIDBStoreNameList' and type = 5
END
GO

	CREATE FUNCTION getSIDBStoreNameList(@i_jobId INT, @i_commCellId INT)
	RETURNS VARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @nameStr VARCHAR(MAX)
		DECLARE @tblJobSIDBStoreNameList TABLE (jobId INT, commCellId INT, SIDBStoreName NVARCHAR(256))
		INSERT INTO @tblJobSIDBStoreNameList
		SELECT DISTINCT AF.jobId, AF.commCellId, SS.SIDBStoreName
		FROM archFile AF WITH (NOLOCK), archFileSILOVolume AFSV WITH (NOLOCK), MMVolume V WITH (NOLOCK), idxSIDBStore SS WITH (NOLOCK)
		WHERE	AF.jobId = @i_jobId
		AND		AF.commCellId = @i_commCellId
		AND		AF.id = AFSV.archFileId
		AND		AF.commCellId = AFSV.commCellId
		AND		AFSV.siloVolumeId = V.volumeId
		AND		AFSV.commCellId = (CASE V.origCCcommCellId WHEN 0 THEN 2 ELSE V.origCCcommCellId END)
		AND		V.SIDBStoreId = SS.SIDBStoreId
		AND		SS.commCellId = (CASE V.origCCcommCellId WHEN 0 THEN 2 ELSE V.origCCcommCellId END)
		AND		V.SIDBStoreId > 0
		SELECT @nameStr=COALESCE(@nameStr + ', ', '') + TT.SIDBStoreName
		FROM @tblJobSIDBStoreNameList TT
		RETURN ISNULL(@nameStr, '')
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getSIDBStoreNameList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getSIDBStoreNameList' AND revision = '1.1.290.1')

  insert into GXDBVersions values(5, 'getSIDBStoreNameList',  '1.1.290.1', 'getSIDBStoreNameList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
