

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getRecentSuccessCITimeOfHold.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getRecentSuccessCITimeOfHold'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getRecentSuccessCITimeOfHold]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getRecentSuccessCITimeOfHold]
  delete from GXDBVersions where name = 'getRecentSuccessCITimeOfHold' and type = 5
END
GO

	CREATE FUNCTION getRecentSuccessCITimeOfHold (@i_ClientId int, @i_HoldType int)
	RETURNS INT
	AS
	BEGIN
	-- start function body
	RETURN
	(
		SELECT
			  TOP 1 servStartDate
		FROM
			  JMBkpStats J WITH (NOLOCK)
		INNER JOIN
		(
			  SELECT jobId, commCellId from archFile WITH (NOLOCK)
			  WHERE fileType = 1 AND appid in
				(
					SELECT Id FROM APP_Application TA WITH (NOLOCK)
					WHERE TA.ClientId = @i_ClientId AND TA.appTypeId IN (SELECT appType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType))
				)
			  GROUP BY jobId , commCellId
			  HAVING MIN(flags) = 64 and MAX(flags) = 64
		) T
		ON
			  J.jobId = T.jobId AND J.CommCellId = T.commCellId
		INNER JOIN
			  APP_Application A WITH (NOLOCK)
		ON
			  A.id = J.appId
		WHERE
			  A.clientId IN (@i_ClientId) AND A.appTypeId IN (SELECT appType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType))
				AND J.status in (1, 3, 14)
		ORDER BY
			  J.jobId desc
	)
	-- end function body
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getRecentSuccessCITimeOfHold]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getRecentSuccessCITimeOfHold' AND revision = '1.3')

  insert into GXDBVersions values(5, 'getRecentSuccessCITimeOfHold',  '1.3', 'getRecentSuccessCITimeOfHold', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
