

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getMappedCategoryPermissionRecurXML.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getMappedCategoryPermissionRecurXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getMappedCategoryPermissionRecurXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getMappedCategoryPermissionRecurXML]
  delete from GXDBVersions where name = 'getMappedCategoryPermissionRecurXML' and type = 5
END
GO

CREATE FUNCTION getMappedCategoryPermissionRecurXML
(
@categoryId INT,
@entityType INT
)
RETURNS XML
AS
BEGIN
DECLARE @returnXML XML
IF EXISTS (SELECT 1 FROM dbo.getAllPermissionsForCategory(@categoryId, 1) APC INNER JOIN UMPermissionEntityTypeMap PE ON APC.permissionId = PE.permissionId WHERE PE.entityType = @entityType)
BEGIN
SET @returnXML = (SELECT
(SELECT C1.id AS '@categoryId',
C1.categoryname AS '@categoryName'
FOR XML PATH ('category'), TYPE),
(SELECT id AS '@permissionId',
permissionName AS '@permissionName'
FROM UMPermissions P INNER JOIN UMPermissionEntityTypeMap PE
ON P.id = PE.permissionId
WHERE PE.entityType = @entityType AND P.categoryId = C1.id AND (P.flags & 0x002 = 0)			--use macro 0x002
FOR XML PATH ('permissionsList'), TYPE),
(SELECT dbo.getMappedCategoryPermissionRecurXML(C2.id, @entityType)
FROM UMCategories C2
WHERE C2.parentCategoryId = @categoryId
FOR XML PATH (''), TYPE)
FROM UMCategories C1
WHERE id = @categoryId
FOR XML PATH ('categoriesList'))
END
RETURN @returnXML
END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getMappedCategoryPermissionRecurXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getMappedCategoryPermissionRecurXML' AND revision = '')

  insert into GXDBVersions values(5, 'getMappedCategoryPermissionRecurXML',  '', 'getMappedCategoryPermissionRecurXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
