

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getItemCountInLatestCycleOfHold.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getItemCountInLatestCycleOfHold'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getItemCountInLatestCycleOfHold]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getItemCountInLatestCycleOfHold]
  delete from GXDBVersions where name = 'getItemCountInLatestCycleOfHold' and type = 5
END
GO

	CREATE FUNCTION getItemCountInLatestCycleOfHold (@i_ClientId int, @i_HoldType int)
	RETURNS INT
	AS
	BEGIN
	-- start function body
	RETURN
		(
		SELECT SUM(J.totalNumOfFiles)
		FROM JMBkpStats J WITH (NOLOCK)
		INNER JOIN
			APP_Application A WITH(NOLOCK)
		ON
			J.appId = A.id
		INNER JOIN
				  APP_SubClientProp SP WITH(NOLOCK)
			ON
				SP.componentNameId = A.id AND SP.attrName = 'sys:full cycle num' AND SP.attrVal = J.fullCycleNum
		WHERE A.clientId = (@i_ClientId) AND A.appTypeId IN (SELECT appType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType))
		AND j.status in ( 1 , 3 , 14)
		)
	-- end function body
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getItemCountInLatestCycleOfHold]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getItemCountInLatestCycleOfHold' AND revision = '1.3')

  insert into GXDBVersions values(5, 'getItemCountInLatestCycleOfHold',  '1.3', 'getItemCountInLatestCycleOfHold', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
