

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHoldsToAppTypeMapping.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getHoldsToAppTypeMapping'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHoldsToAppTypeMapping]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHoldsToAppTypeMapping]
  delete from GXDBVersions where name = 'getHoldsToAppTypeMapping' and type = 5
END
GO

	CREATE FUNCTION getHoldsToAppTypeMapping (@HoldTypes varchar(max) = '')
	RETURNS
	@supportedRefAppTypes TABLE (
			refAppType			integer,
			appType				integer
		)
	AS
	BEGIN
	DECLARE @appTypeHoldType TABLE
	(
		appType			integer,
		holdType		integer
	)
	Insert Into @appTypeHoldType values(33/*File System*/, 4)
	Insert Into @appTypeHoldType values(29/*File System*/, 4)
	Insert Into @appTypeHoldType values(54/*Mail Box*/, 5)
	Insert Into @appTypeHoldType values(67/*Journal*/, 6)
	-- Populate the supported AppTypes
	Insert Into @supportedRefAppTypes values(33, 11)
	Insert Into @supportedRefAppTypes values(33, 34)
	Insert Into @supportedRefAppTypes values(33, 42)
	Insert Into @supportedRefAppTypes values(33, 43)
	Insert Into @supportedRefAppTypes values(33, 1)
	Insert Into @supportedRefAppTypes values(29, 17)
	Insert Into @supportedRefAppTypes values(29, 18)
	Insert Into @supportedRefAppTypes values(29, 19)
	Insert Into @supportedRefAppTypes values(29, 20)
	Insert Into @supportedRefAppTypes values(29, 21)
	Insert Into @supportedRefAppTypes values(29, 29)
	Insert Into @supportedRefAppTypes values(29, 36)
	Insert Into @supportedRefAppTypes values(29, 38)
	Insert Into @supportedRefAppTypes values(29, 63)
	Insert Into @supportedRefAppTypes values(29, 64)
	Insert Into @supportedRefAppTypes values(29, 74)
	Insert Into @supportedRefAppTypes values(54, 54)
	Insert Into @supportedRefAppTypes values(67, 67)
	Insert Into @supportedRefAppTypes values(33, 33)
	Insert Into @supportedRefAppTypes values(29, 29)
 	-- logic for returning appropriate app-types for requested hold types
	IF ISNULL(@HoldTypes, '') <> ''
	BEGIN
		--For review set, all app-type are applicable and so we delete nothing from main mapping table
		IF NOT EXISTS (SELECT TOP 1 * FROM dbo.SplitIDs(@holdTypes) R WHERE R._ID = 7)
		BEGIN
			--Delete app-types other than the one for the requested hold types so that we return only what is desired
			DELETE FROM @supportedRefAppTypes
			WHERE refAppType  NOT IN
			(
				SELECT apptype FROM @appTypeHoldType A
				INNER JOIN dbo.SplitIDs(@holdTypes) R ON A.holdType = R._ID
			)
		END
	END
	-- Done with logic, now return..
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHoldsToAppTypeMapping]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHoldsToAppTypeMapping' AND revision = '1.2.48.1')

  insert into GXDBVersions values(5, 'getHoldsToAppTypeMapping',  '1.2.48.1', 'getHoldsToAppTypeMapping', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
