

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHTMLTableFromXML.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: getHTMLTableFromXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHTMLTableFromXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHTMLTableFromXML]
  delete from GXDBVersions where name = 'getHTMLTableFromXML' and type = 5
END
GO

 CREATE FUNCTION getHTMLTableFromXML (
     		@i_inXML		XML
     	)
     	RETURNS @htmlTblStr TABLE (
     		tblStr NVARCHAR(MAX)
     	)
     	AS
     	BEGIN

 			DECLARE @columnsList TABLE (id INT IDENTITY, columnName NVARCHAR(256))
 			DECLARE @columnName NVARCHAR(256)
 			DECLARE @numberOfRows INT

 			SELECT @numberOfRows = @i_inXML.value('count(/Results/TableResults/Row)', 'int')

 			INSERT INTO @columnsList(columnName)
 			SELECT	T.cc.value('@columnName', 'nvarchar(1024)')
 			FROM	@i_inXML.nodes('/Results/TableResults/Row[1]/Column') T(cc)


 			-- Create table Header
 			DECLARE @th NVARCHAR(MAX) = N''
 			DECLARE @td NVARCHAR(MAX) = N''
 			DECLARE columnCursor CURSOR FOR
 			SELECT columnName FROM @columnsList ORDER BY id
 			OPEN columnCursor
 			FETCH FROM columnCursor INTO @columnName
 			WHILE @@FETCH_STATUS = 0
 			BEGIN
 				SET @th += '<TH style="background-color: #666666;color: #FFFFFF;padding: 5px;font-weight: bold;text-align: left;font-size: 12px !important;">'+ @columnName + '</TH>'
 				FETCH FROM columnCursor INTO @columnName
 			END
 			CLOSE columnCursor
 			IF @th <> ''
 				SET @th = '<TR class="header" style="padding-right: 0; margin-left: 0; padding-top: 15px; margin-top: 5px; border-left-width: 1px; border-right-width: 1px; border-left-style: solid; padding-bottom: 15px; border-right-style: solid; border-top-style: solid; border-bottom-style: solid; border-top-width: 1px; margin-bottom: 5px; border-bottom-width: 1px; font-size: 12px; margin-right: 0; background-color: #F4F4F4; padding-left: 0; text-align: center;">' + @th + '</TR>'

 			DECLARE @rowIndex INT = 1
 			DECLARE @temp NVARCHAR(1024) = N''
 			WHILE @rowIndex <= @numberOfRows
 			BEGIN
 				IF @rowIndex % 2 = 0
 					SET @td += '<TR class="even">'
 				ELSE
 					SET @td += '<TR class="odd">'
 				OPEN columnCursor
 				FETCH FROM columnCursor INTO @columnName
 				WHILE @@FETCH_STATUS = 0
 				BEGIN
 					SELECT	@temp = T.cc.value('Row[sql:variable("@rowIndex")][1]/Column[@columnName=sql:variable("@columnName")][1]/text()[1]', 'nvarchar(1024)')
 					FROM	@i_inXML.nodes('/Results/TableResults') T(cc)
 					IF @rowIndex % 2 = 0
 						SET @td += '<TD style="background-color: #F9F9F9;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
 					ELSE
 						SET @td += '<TD style="background-color: #EAEAEA;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
 					FETCH FROM columnCursor INTO @columnName
 				END
 				CLOSE columnCursor
 				SET @rowIndex = @rowIndex + 1
 				SET @td += '</TR>'
 			END

 			DEALLOCATE columnCursor
 			INSERT INTO @htmlTblStr
 			SELECT '<TABLE class="datatable" style="border: 1px solid #CCCCCC;border-collapse: collapse;color: #444444 !important;font-family: helvetica,arial,sans-serif;font-size: 12px !important;width: 100%;text-align: left;">'+@th+@td+'</TABLE>'

     		RETURN
     	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHTMLTableFromXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHTMLTableFromXML' AND revision = '1.4')

  insert into GXDBVersions values(5, 'getHTMLTableFromXML',  '1.4', 'getHTMLTableFromXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
