

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHTMLTableForAlerts.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: getHTMLTableForAlerts'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHTMLTableForAlerts]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHTMLTableForAlerts]
  delete from GXDBVersions where name = 'getHTMLTableForAlerts' and type = 5
END
GO

 CREATE FUNCTION getHTMLTableForAlerts (
     		@i_inXML		XML
     	)
     	RETURNS @htmlTblStr TABLE (
     		tblStr NVARCHAR(MAX)
     	)
     	AS
     	BEGIN
 			DECLARE @newTemplate INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name='UseNewAlertTemplate'),0)
 			DECLARE @columnsList TABLE (id INT IDENTITY, columnName NVARCHAR(256),shldBePartOfOutput int)
 			DECLARE @rowColList table (rowId int,colIndex int,colVal nvarchar(max))
 			DECLARE @columnName NVARCHAR(256)
 			DECLARE @shldBePartOfOutput int
 			DECLARE @numberOfRows INT
 			set @numberOfRows = 0

 			SELECT @numberOfRows = @i_inXML.value('count(App_ExternalQueryResults/resultSet)', 'int')

 			INSERT INTO @columnsList(columnName,shldBePartOfOutput)
 			SELECT	T.cc.value('@val', 'nvarchar(1024)'),1
 			FROM	@i_inXML.nodes('App_ExternalQueryResults/colList/columnName') T(cc)

 			iNSERT INTO @rowColList
 			SELECT	T.cc.value('for $i in . return count(../../*[local-name(.)=''resultSet'' and . << $i])', 'int'),
			T.cc.value('for $j in . return count(../*[local-name(.)=''colValues'' and . << $j])', 'int')+1,
 			T.cc.value('@val', 'nvarchar(1024)')
 			FROM	@i_inXML.nodes('App_ExternalQueryResults/resultSet/colValues') T(cc)


 			declare @CountOfColumns int = 0
 			select @CountOfColumns = count(*) from @columnsList

 			-- Create table Header
 			DECLARE @th NVARCHAR(MAX) = N''
 			DECLARE @td NVARCHAR(MAX) = N''
 			DECLARE columnCursor CURSOR FOR
 			SELECT columnName,shldBePartOfOutput FROM @columnsList ORDER BY id
 			OPEN columnCursor
 			FETCH FROM columnCursor INTO @columnName,@shldBePartOfOutput
 			WHILE @@FETCH_STATUS = 0
 			BEGIN
 				if @shldBePartOfOutput=1
 				begin
					IF @newTemplate = 0
 						SET @th += '<TH style="background-color: #666666;color: #FFFFFF;padding: 5px;font-weight: bold;text-align: left;font-size: 12px !important;">'+ @columnName + '</TH>'
					ELSE
 						SET @th += '<TH style="background-color: #2f4e66;color: #FFFFFF;padding: 5px;font-weight: bold;text-align: left;font-size: 12px !important;">'+ @columnName + '</TH>'
 				end
 				FETCH FROM columnCursor INTO @columnName,@shldBePartOfOutput
 			END
 			CLOSE columnCursor
			IF @th <> ''
				IF @newTemplate = 0
	                SET @th = '<TR class="header" style="padding-right: 0; margin-left: 0; padding-top: 15px; margin-top: 5px; border-left-width: 1px; border-right-width: 1px; border-left-style: solid; padding-bottom: 15px; border-right-style: solid; border-top-style: solid; border-bottom-style: solid; border-top-width: 1px; margin-bottom: 5px; border-bottom-width: 1px; font-size: 12px; margin-right: 0; background-color: #F4F4F4; padding-left: 0; text-align: center;">' + @th + '</TR>'
				ELSE
                	SET @th = '<TR class="header" style="padding-right: 0; margin-left: 0; padding-top: 15px; margin-top: 5px; border-left-width: 1px; border-right-width: 1px; border-left-style: solid; padding-bottom: 15px; border-right-style: solid; border-top-style: solid; border-bottom-style: solid; border-top-width: 1px; margin-bottom: 5px; border-bottom-width: 1px; font-size: 12px; margin-right: 0; background-color: #2f4e66; padding-left: 0; text-align: center;">' + @th + '</TR>'

 			DECLARE @rowIndex INT = 1
 			DECLARE @colIndexTemp INT = 1
 			DECLARE @temp NVARCHAR(1024) = N''
 			WHILE @rowIndex <= @numberOfRows
 			BEGIN
 				IF @rowIndex % 2 = 0
                    SET @td += '<TR class="even">'
                ELSE
                    SET @td += '<TR class="odd">'
 				set @colIndexTemp = 1

 				WHILE @colIndexTemp<=@CountOfColumns
 				BEGIN
 					set @shldBePartOfOutput = 1
 					select  @shldBePartOfOutput = shldBePartOfOutput from @columnsList
 					where id = @colIndexTemp

 					if (@shldBePartOfOutput = 1)
 					begin
 						set @temp = ''
 						SELECT	@temp = colVal FROM @ROWCOLList where rowId=@rowIndex and colIndex=@colIndexTemp
 						IF @rowIndex % 2 = 0
 						begin
							IF @newTemplate = 0
								SET @td += '<TD style="background-color: #F9F9F9;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
					        ELSE
								SET @td += '<TD style="background-color: #f5f5f5;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
						end
						ELSE
						begin
							IF @newTemplate = 0
								SET @td += '<TD style="background-color: #EAEAEA;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
							ELSE
								SET @td += '<TD style="padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
						end
 					end
 					set @colIndexTemp = @colIndexTemp + 1
 				END

 				SET @rowIndex = @rowIndex + 1
 				SET @td += '</TR>'
 			END

 			DEALLOCATE columnCursor
			IF @newTemplate = 0
	 			INSERT INTO @htmlTblStr
 				SELECT '<div id="contentTbl-table-scroll"><TABLE class="datatable" style="border: 1px solid #CCCCCC;border-collapse: collapse;color: #444444 !important;font-family: helvetica,arial,sans-serif;font-size: 12px !important;width: 100%;text-align: left;">'+@th+@td+'</TABLE></div>'
			ELSE
 				INSERT INTO @htmlTblStr
 				SELECT '<div id="contentTbl-table-scroll"><TABLE class="datatable" style="border: 1px solid #2f4e66;border-collapse: collapse;color: #444444 !important;font-family: sans-serif;font-size: 12px !important;width: 100%;text-align: left;">'+@th+@td+'</TABLE></div>'

     		RETURN
     	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHTMLTableForAlerts]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHTMLTableForAlerts' AND revision = '1.3.68.4')

  insert into GXDBVersions values(5, 'getHTMLTableForAlerts',  '1.3.68.4', 'getHTMLTableForAlerts', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
