

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getGenericXMLFromEntityType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getGenericXMLFromEntityType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getGenericXMLFromEntityType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getGenericXMLFromEntityType]
  delete from GXDBVersions where name = 'getGenericXMLFromEntityType' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION getGenericXMLFromEntityType(@entityType1 INT, @entityId1 INT, @entityType2 INT, @entityId2 INT, @entityType3 INT, @entityId3 INT, @entityType4 INT, @entityId4 INT, @entityType5 INT, @entityId5 INT, @exclude INT , @includeAll INT, @returnvariable NVARCHAR(MAX))
	RETURNS XML
	AS
	BEGIN
	DECLARE @xmlRet AS XML
	DECLARE @entityType INT= (SELECT dbo.getEntityLevelFromEntityHierarchy(@entityType1,@entityType2,@entityType3,@entityType4,@entityType5))
	DECLARE @entityTypeName AS NVARCHAR(MAX)
	IF @entityType IN (3,4,5,6,7)
	BEGIN
		SET @xmlRet = (SELECT
				CASE WHEN @entityType1 = 3 THEN @entityId1 END AS '@clientId',
				CASE WHEN @entityType2 = 4 THEN @entityId2 END AS '@applicationId',
				CASE WHEN @entityType3 = 5 THEN @entityId3 END AS '@instanceId',
				CASE WHEN @entityType4 = 6 THEN @entityId4 END AS '@backupsetId',
				CASE WHEN @entityType5 = 7 THEN @entityId5 END AS '@subclientId',
				@entityType AS '@_type_',
				CASE WHEN @exclude = 1 THEN '1' END AS 'flags/@exclude',
				CASE WHEN @includeAll = 1 THEN '1' END AS 'flags/@includeAll'
			FOR XML PATH('entityAssociated'))
	END
	--custom entity
	ELSE IF (SELECT flags & 0x001 FROM APP_Entity WHERE entityTYpe = @entityType) <> 0
	BEGIN
			--let us get in English as for now, will think about localization later
			SET @entityTypeName = ISNULL((SELECT entityTypeName FROM APP_Entity WHERE entityTYpe = @entityType), N'')
			SET @xmlRet = (SELECT 150 AS '@_type_',
					@entityType AS '@entityType',
					@entityId1 AS '@entityId',
					@entityTypeName AS '@entityTypeName',
					CASE WHEN @exclude = 1 THEN '1' END AS 'flags/@exclude',
					CASE WHEN @includeAll = 1 THEN '1' END AS 'flags/@includeAll'
			FOR XML PATH ('entityAssociated'))
	END
	ELSE IF @entityType = 126 OR @includeAll = 1
	BEGIN
		SET @xmlRet = (SELECT @entityType AS '@_type_',
						CASE WHEN @exclude = 1 THEN '1' END AS 'flags/@exclude',
						CASE WHEN @includeAll = 1 THEN '1' END AS 'flags/@includeAll'
					   FOR XML PATH('entityAssociated'))
	END
	ELSE
	BEGIN
		SET @xmlRet = (SELECT @entityId1 AS '@entityId1',
						@entityType AS '@_type_',
 					    CASE WHEN @exclude = 1 THEN '1' END AS 'flags/@exclude',
                        CASE WHEN @includeAll = 1 THEN '1' END AS 'flags/@includeAll'
						FOR XML PATH('entityAssociated'))
		SET @entityTypeName = ISNULL((SELECT entityIdInXML FROM APP_Entity WHERE entityType = @entityType),'')
		IF @entityTypeName <> ''
		BEGIN
			SET @xmlRet = CAST(REPLACE(CAST(@xmlRet AS NVARCHAR(MAX)), 'entityId1', @entityTypeName) AS XML)
		END
	END
	SET @xmlRet = CAST(REPLACE(CAST(@xmlRet AS NVARCHAR(MAX)), 'entityAssociated', @returnvariable) AS XML)
	RETURN @xmlRet
	END
	GO
	SET QUOTED_IDENTIFIER ON
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getGenericXMLFromEntityType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getGenericXMLFromEntityType' AND revision = '')

  insert into GXDBVersions values(5, 'getGenericXMLFromEntityType',  '', 'getGenericXMLFromEntityType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
