

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getClientIPv6WithCIDRMask.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getClientIPv6WithCIDRMask'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getClientIPv6WithCIDRMask]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getClientIPv6WithCIDRMask]
  delete from GXDBVersions where name = 'getClientIPv6WithCIDRMask' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[getClientIPv6WithCIDRMask](@operator VARCHAR(24), @compValue varchar(50), @inClientId INT, @inSCGId INT)
RETURNS @clientIP TABLE (clientId INT, ip VARCHAR(50))
AS
BEGIN
	IF @inClientId=0 AND @inSCGId=0
		RETURN
    DECLARE @opType INT = 0
    DECLARE @InValidIP TINYINT= 1
    SELECT @opType = CASE @operator
                    WHEN '='        THEN 1
                    WHEN '<>'       THEN 2
                END
    IF  (CHARINDEX(',',@compValue)>0 AND CHARINDEX(':',@compValue)>0 AND CHARINDEX('.',@compValue)=0)
    SET @InValidIP=0                                -- Set 0 for Valid Ip
    IF (@opType = 0 or @InValidIP > 0)
    BEGIN
        RETURN
    END
    DECLARE @IPAddress Varchar(50)
    DECLARE @HexetMatch INT
    DECLARE @Cidr INT
    DECLARE @DeterminingNetworkBit INT
    DECLARE @DeterminingHexet INT
    DECLARE @MagicNo INT
    SELECT @Cidr = CAST(RIGHT(@compValue, CHARINDEX(',', REVERSE(@compValue))-1) AS INT)
    SELECT @DeterminingNetworkBit=(@Cidr%16)
    SELECT @IPAddress=LEFT(@compValue,CHARINDEX(',',@compValue)-1)
    SELECT @IPAddress = replace(NULLIF(@IPAddress, ''), '::', REPLICATE(':', 9-LEN(@IPAddress)+LEN(replace(@IPAddress, ':', ''))))
    DECLARE  @InputIP TABLE (Ipaddress varchar(50), Hexet int ,HexValue int)
    INSERT   @InputIP   SELECT IpVal,id, convert(int,CONVERT(VARBINARY, '0x'+right('0000'+convert(varchar(4), S.Data), 4),1))
     FROM (select @IPAddress IPVal )IP   CROSS APPLY dbo.SplitString(IPVal, ':') S
     SELECT @HexetMatch=floor(@Cidr/16)
      SELECT @DeterminingHexet =
    (
       SELECT HexValue
       FROM @InputIP
       WHERE Hexet = @HexetMatch + 1
    )
    DECLARE   @ClientIPList TABLE (ClientID int, IpAddress  varchar(50), IpAddressOriginal varchar(50))
    INSERT INTO @ClientIPList
	SELECT clientId, ip ,ip
	FROM dbo.getClientIPAddress(@inClientId, @inSCGId) IP
	WHERE IP.ip LIKE '%:%'
--Clean Up
 --Delete IPv4
    DELETE C
     FROM @ClientIPList C
                         WHERE C.IpAddress   LIKE '%.%.%.%'
-- Expand IP if shortened
    UPDATE C SET  IpAddress=replace(nullif(IpAddress,''),'::',replicate(':',9-len(IpAddress)+len(replace(IpAddress,':',''))))
    FROm @ClientIPList C
      WHERE IpAddress LIKE '%::%'
    DECLARE @ClientIPListExpanded TABLE
    (Id        INT IDENTITY(1, 1) PRIMARY KEY,
    ClientID  INT,
    IpAddress VARCHAR(50),
    Hexet       INT,
    HexValue    VARCHAR(25),
    HexValueInt INT
    )
    INSERT INTO @ClientIPListExpanded
    (ClientiD,
    IpAddress,
    Hexet,
    HexValue
    )
         SELECT ClientID,
               IpAddress,
               Id,
               Coalesce(s.data,'0000')
         FROM @ClientIPList IP
             CROSS APPLY dbo.SplitString(ip.IpAddress, ':') S
  UPDATE C
  SET HexValue= LEFT(HexValue,CHARINDEX('%',HexValue)-1)
  FROM  @ClientIPListExpanded C
       where HexValue LIKE '%\%%' ESCAPE '\'--) IpCleanUp
UPDATE C
  SET HexValue= right('0000'+convert(varchar(4), HexValue), 4)
   from @ClientIPListExpanded C WHERE LEN(HexValue)<4
UPDATE C
  SET HexValueInt=convert(int, convert(varbinary,'0x'+HexValue, 1))
   FROM @ClientIPListExpanded C
   DECLARE @IPNetworkMatch TABLE
    (    Id int IDENTITY(1,1) Primary KEY ,
         ClientID int,
         IpAddress  varchar(50),
        Hexet INT,
        HexValue INT)
 IF @HexetMatch>0
 BEGIN
       INSERT INTO @IPNetworkMatch
       (ClientID,
        IpAddress
       )
            SELECT a.ClientID,
                  a.Ipaddress
            FROM @ClientIPListExpanded a
                JOIN @InputIP b ON a.Hexet = b.Hexet
                                AND ISNULL(a.HexValueInt,0)&65535 = b.HexValue&65535
                                AND b.Hexet <= @HexetMatch
            GROUP BY a.ClientID,
                    a.Ipaddress
            HAVING COUNT(a.Hexet) = @HexetMatch
            ORDER by 1
 END
ELSE
BEGIN
       INSERT INTO @IPNetworkMatch
          (ClientID,
           IpAddress
          )
            SELECT a.ClientID,
                  a.Ipaddress
            FROM @ClientIPListExpanded a
                JOIN @InputIP b ON a.Hexet = b.Hexet
                WHERE a.hexet=1  --First hexet
END
       UPDATE a
        SET
            a.Hexet = b.Hexet,
            a.HexValue = b.HexValueInt
       FROM @IPNetworkMatch a
           JOIN @ClientIPListExpanded b ON a.ClientID = b.ClientID
                                    AND a.IpAddress = b.IpAddress
       WHERE b.Hexet = @HexetMatch + 1  --- Hexet which is the one which determines network /hostpart
    DECLARE   @NetworkBit Table (Id int,Val int)
    INSERT @NetworkBit
    VALUES
      (1, 32768)  -- 10000000 00000000
    , (2, 49152)  -- 11000000 00000000
    , (3, 57344)  -- 11100000 00000000
    , (4, 61440)  -- 11110000 00000000
    , (5, 63488)  -- 11111000 00000000
    , (6, 64512)  -- 11111100 00000000
    , (7, 65024)  -- 11111110 00000000
    , (8, 65280)  -- 11111111 00000000
    , (9, 65408)  -- 11111111 10000000
    , (10, 65472)  -- 11111111 11000000
    , (11, 65504)  -- 11111111 11100000
    , (12, 65520)  -- 11111111 11110000
    , (13, 65528)  -- 11111111 11111000
    , (14, 65532)  -- 11111111 11111100
    , (15, 65534)  -- 11111111 11111110
    , (16, 65535)  -- 11111111 11111111
    SELECT @MagicNo = ISNULL(
                       (
                          SELECT val
                          FROM @NetworkBit
                          WHERE id = @DeterminingNetworkBit
                       ), 0);
  IF @inClientId<>0
  BEGIN
   IF @opType=1
	INSERT INTO @clientIP
         SELECT IPNM.ClientID, CIPLIST.IpAddressOriginal
         FROM @IPNetworkMatch IPNM
		 INNER JOIN @ClientIPList CIPLIST
		 ON CIPLIST.ClientID = IPNM.ClientID
         WHERE(HexValue&@MagicNo) = @DeterminingHexet&@MagicNo
         AND CIPLIST.ClientID = @inClientId
   IF @opType=2
    INSERT INTO @clientIP
		SELECT CIPLIST.ClientID, CIPLIST.IpAddressOriginal
		FROM @ClientIPList CIPLIST
		INNER JOIN (
			SELECT ClientID, IpAddress
			FROM @ClientIPList
			WHERE  ClientID = @inClientId
			EXCEPT
			SELECT ClientID, IpAddress
			FROM @IPNetworkMatch
			WHERE(HexValue&@MagicNo) = @DeterminingHexet&@MagicNo AND ClientID =@inClientId
		) TEMP
		ON CIPLIST.ClientID=TEMP.ClientID
  END
  ELSE IF @inSCGId<>0
  BEGIN
	IF @opType=1
	INSERT INTO @clientIP
         SELECT CIPLIST.ClientID, CIPLIST.IpAddressOriginal
		 FROM @ClientIPList CIPLIST
		 INNER JOIN(
			 SELECT IP.ClientID from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
			 INNER JOIN  @IPNetworkMatch IP
			 ON ACGA.clientId=IP.ClientID AND ACGA.clientGroupId=@inSCGId
			 WHERE(HexValue&@MagicNo) = @DeterminingHexet&@MagicNo
		 ) TEMP
		 ON CIPLIST.ClientID = TEMP.ClientID
    IF @opType=2
	INSERT INTO @clientIP
		 SELECT CIPLIST.ClientID, CIPLIST.IpAddressOriginal
		 FROM @ClientIPList CIPLIST
		 INNER JOIN(
			 SELECT IP.ClientID, IpAddress
			 FROM APP_ClientGroupAssoc ACGA WITH(NOLOCK)
			 INNER JOIN @ClientIPList IP
			 ON ACGA.clientId=IP.ClientID AND ACGA.clientGroupId=@inSCGId
			 EXCEPT
			 SELECT IP.ClientID, IpAddress
			 FROM APP_ClientGroupAssoc ACGA WITH(NOLOCK)
			 INNER JOIN @IPNetworkMatch IP
			 ON ACGA.clientId=IP.ClientID AND ACGA.clientGroupId=@inSCGId
			 WHERE(HexValue&@MagicNo) = @DeterminingHexet&@MagicNo
			 )TEMP
			 ON CIPLIST.ClientID = TEMP.ClientID
  END
    RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getClientIPv6WithCIDRMask]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getClientIPv6WithCIDRMask' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'getClientIPv6WithCIDRMask',  '1.1.2.3', 'getClientIPv6WithCIDRMask', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
