

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getClientIPv4WithCIDRMask.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getClientIPv4WithCIDRMask'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getClientIPv4WithCIDRMask]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getClientIPv4WithCIDRMask]
  delete from GXDBVersions where name = 'getClientIPv4WithCIDRMask' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION getClientIPv4WithCIDRMask(@operator VARCHAR(24), @compValue varchar(18), @inClientId INT, @inCGId INT)
RETURNS @clientIP TABLE (clientId INT, ip varchar(15))
AS
BEGIN
	IF @inClientId = 0 AND @inCGId = 0
		RETURN
	DECLARE @opType INT = 0
    DECLARE @InValidIP TINYINT= 1
	SELECT @opType = CASE @operator
                    WHEN '='		THEN 1
                    WHEN '<>'		THEN 2
                END
    IF @compValue LIKE '%_.%_.%_.%_,%'
        AND @compValue NOT LIKE '%.%.%.%.%'
        AND @compValue NOT LIKE '%[^0-9.,]%'
        AND @compValue NOT LIKE '%[0-9][0-9][0-9][0-9]%'
        AND @compValue NOT LIKE '%[3-9][0-9][0-9]%'
        AND @compValue NOT LIKE '%2[6-9][0-9]%'
        AND @compValue NOT LIKE '%25[6-9]%'
        AND @compValue NOT LIKE '%,[3-9][3-9]%'
        AND @compValue NOT LIKE '%[a-z]%'
        AND CHARINDEX('%',@compValue) =0
        SET @InValidIP=0                                 -- Set 0 for Valid Ip
	IF (@opType = 0 or @InValidIP > 0)
	BEGIN
		RETURN
	END
	DECLARE @Mask INT;
	DECLARE @Base BIGINT= 4294967295;					--2^32
	DECLARE @Power BIGINT;
	DECLARE @LowRangeIP BIGINT;
	DECLARE @HighRangeIP BIGINT;
	DECLARE @IPAddress VARCHAR(15);
    DECLARE @IPAddressDecimal BIGINT
	SELECT @IPAddress = LEFT(@compValue, CHARINDEX(',', @compValue)-1);
	SELECT @mask = CAST(RIGHT(@compValue, CHARINDEX(',', REVERSE(@compValue))-1) AS INT);
	SELECT @Power = POWER(2.0, 32.0 - @Mask) - 1;						  --(Hosts-1)
    SELECT @IPAddressDecimal=	  CONVERT(BIGINT, PARSENAME(@IPAddress, 1)) +
                                CONVERT(BIGINT, PARSENAME(@IPAddress, 2)) * 256 +
                                CONVERT(BIGINT, PARSENAME(@IPAddress, 3)) * 65536 +
                                CONVERT(BIGINT, PARSENAME(@IPAddress, 4)) * 16777216
	SELECT @LowRangeIP =  @IPAddressDecimal&(@Base^@Power);
	SELECT @HighRangeIP = @LowRangeIP + @Power;
   IF (@opType = 1)
	BEGIN
		INSERT INTO @clientIP
		SELECT DISTINCT Ip.clientId, IP.ip
		FROM dbo.getClientIPv4DecimalRepresentation(@inClientId, @inCGId) IP
		WHERE(Ip.IpAddressDecimal > @LowRangeIP
				AND Ip.IpAddressDecimal < @HighRangeIP);
	END ELSE
	IF (@opType = 2)
	BEGIN
		 DECLARE  @IPAddressList TABLE(
										ClientID int,
										IpAddress  varchar(15),
										IpAddressDecimal BIGINT  DEFAULT 0
										PRIMARY KEY (ClientID,IpAddressDecimal)
									)
		INSERT INTO @IPAddressList
		SELECT clientId, ip, IpAddressDecimal
		FROM dbo.getClientIPv4DecimalRepresentation(@inClientId, @inCGId)
		INSERT INTO @clientIP
		SELECT ClientID, IpAddress
		FROM @IPAddressList
		EXCEPT
		SELECT ClientID, IpAddress
		FROM @IPAddressList
		WHERE(IpAddressDecimal > @LowRangeIP
				AND IpAddressDecimal < @HighRangeIP);
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getClientIPv4WithCIDRMask]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getClientIPv4WithCIDRMask' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'getClientIPv4WithCIDRMask',  '1.1.2.2', 'getClientIPv4WithCIDRMask', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
