

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getClientIPv4DecimalRepresentation.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getClientIPv4DecimalRepresentation'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getClientIPv4DecimalRepresentation]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getClientIPv4DecimalRepresentation]
  delete from GXDBVersions where name = 'getClientIPv4DecimalRepresentation' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[getClientIPv4DecimalRepresentation](@inClientId INT, @inCGId INT)
RETURNS @clientIPv4Decimal TABLE (clientId INT, ip VARCHAR(50), IpAddressDecimal BIGINT DEFAULT 0)
AS
BEGIN
	INSERT INTO @clientIPv4Decimal(clientId, ip, IpAddressDecimal)
	SELECT IP.clientId, IP.ip,
			(CONVERT(BIGINT, PARSENAME(IP.ip, 1))
	                             + CONVERT(BIGINT, PARSENAME(IP.ip, 2)) * 256
	                             + CONVERT(BIGINT, PARSENAME(IP.ip, 3)) * 65536
	                             + CONVERT(BIGINT, PARSENAME(IP.ip, 4)) * 16777216)
	FROM dbo.getClientIPAddress(@inClientId, @inCGId) IP
	WHERE IP.ip LIKE '%.%.%.%'
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getClientIPv4DecimalRepresentation]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getClientIPv4DecimalRepresentation' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'getClientIPv4DecimalRepresentation',  '1.1.2.2', 'getClientIPv4DecimalRepresentation', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
