

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getClientIPAddress.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getClientIPAddress'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getClientIPAddress]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getClientIPAddress]
  delete from GXDBVersions where name = 'getClientIPAddress' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[getClientIPAddress](@inClientId INT, @inCGId INT)
RETURNS @clientIP TABLE (clientId INT, ip VARCHAR(50))
AS
BEGIN
DECLARE @IPAddressesPropertyTypeId INT = 2102	-- Defined in appMgrComponentDefines.h
	IF @inClientId<>0
	BEGIN
		INSERT INTO @clientIP (clientId, ip)
		SELECT   componentId, LTRIM(RTRIM(S.Data))
		FROM APP_ComponentProp(NOLOCK) ACP
		CROSS APPLY dbo.SplitString(ACP.stringVal, ',') S
        WHERE propertyTypeId = @IPAddressesPropertyTypeId AND modified = 0 AND componentId=@inClientId
	END
	ELSE IF @inCGId<>0
	BEGIN
		INSERT INTO @clientIP (clientId, ip)
		SELECT   componentId, LTRIM(RTRIM(S.Data))
		FROM APP_ClientGroupAssoc(NOLOCK) ACGA
		INNER JOIN APP_ComponentProp(NOLOCK) ACP
		ON ACGA.clientId=ACP.componentId AND ACGA.clientGroupId=@inCGId
		CROSS APPLY dbo.SplitString(ACP.stringVal, ',') S
        WHERE propertyTypeId = @IPAddressesPropertyTypeId AND modified = 0
	END
	ELSE
	BEGIN
		-- Consider ALL clients
		INSERT INTO @clientIP (clientId, ip)
		SELECT   componentId, LTRIM(RTRIM(S.Data))
		FROM APP_ComponentProp(NOLOCK) ACP
		CROSS APPLY dbo.SplitString(ACP.stringVal, ',') S
        WHERE propertyTypeId = @IPAddressesPropertyTypeId AND modified = 0
	END
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getClientIPAddress]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getClientIPAddress' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'getClientIPAddress',  '1.1.2.3', 'getClientIPAddress', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
