

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getCIStatusText.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getCIStatusText'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getCIStatusText]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getCIStatusText]
  delete from GXDBVersions where name = 'getCIStatusText' and type = 5
END
GO

	CREATE FUNCTION getCIStatusText (@jobId int, @localeId int)
	RETURNS nvarchar(2048)
	AS
	BEGIN
	-- declarations
	DECLARE @dataFilesCount int = 0
	DECLARE @successCICount int = 0
	DECLARE @partialCount int = 0
	DECLARE @pickedCount int = 0
	DECLARE @failedCount int = 0
	DECLARE @expiredCount int = 0
	DECLARE @notPickedCount int = 0
	DECLARE @status int = 0
	--determine counts in order to compute ci status of job..
	--SELECT @successCICount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_SUCCESS_FLAG = CVA_AF_CI_SUCCESS_FLAG
	--SELECT @partialCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_PARTIAL_FLAG = CVA_AF_CI_PARTIAL_FLAG
	--SELECT @pickedCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_REQUIRED_FLAG = CVA_AF_CI_REQUIRED_FLAG
	--SELECT @failedCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_FAILURE_FLAG = CVA_AF_CI_FAILURE_FLAG
	--SELECT @expiredCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_EXPIRED_FLAG = CVA_AF_CI_EXPIRED_FLAG
	--SELECT @notPickedCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags = 0
	--SELECT @dataFilesCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1
	SELECT @successCICount = CASE WHEN T.flags = 64 THEN T.FlagCount END,
	@partialCount = CASE WHEN T.flags = 32 THEN T.FlagCount END,
	@pickedCount = CASE WHEN T.flags = 16 THEN T.FlagCount END,
	@failedCount = CASE WHEN T.flags = 128 THEN T.FlagCount END,
	@expiredCount = CASE WHEN T.flags = 256 THEN T.FlagCount END,
	@notPickedCount = CASE WHEN T.flags = 0 THEN T.FlagCount END
	FROM
	(
	SELECT COUNT(flags) FlagCount, flags FROM archFile WITH(NOLOCK)
	WHERE jobid = @jobId AND isValid = 1 and fileType = 1
	GROUP BY FLAGS
	) T
	SELECT @dataFilesCount = COUNT(id) FROM archFile WITH(NOLOCK) WHERE jobid = @jobId AND isValid = 1 and fileType = 1
	--computing ci status of job now..
	IF @pickedCount > 0 AND @pickedCount = @dataFilesCount
	BEGIN
		SET @status = 16
		--PRINT 'Picked'
	END
	ELSE IF @successCICount > 0 AND @successCICount = @dataFilesCount
	BEGIN
		SET @status = 64
		--PRINT 'Success'
	END
	ELSE IF @notPickedCount > 0
	BEGIN
		SET @status = 0
		--PRINT 'Not Picked'
	END
	ELSE IF @failedCount > 0 AND @failedCount = @dataFilesCount
	BEGIN
		SET @status = 128
		--PRINT 'Failed'
	END
	ELSE IF @successCICount > 0 OR @partialCount > 0
	BEGIN
		SET @status = 32
		--PRINT 'Partial'
	END
	ELSE
	BEGIN
		SET @status = (371 | (CAST(POWER(2, 24) AS BIGINT) * 61))
		--PRINT 'Unknown'
	END
	-- start function body
	DECLARE @messageId int = CASE
	WHEN @status = 16 THEN (507 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 32 THEN (1595 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 64 THEN (881 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 128 THEN (579 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 256 THEN (1199 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 0 THEN (508 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	END
	-- Return localized message from here.
	RETURN
	(
	SELECT TOP 1 Message FROM EvLocaleMsgs
	WHERE SubsystemID = 61 AND LocaleId = @localeId AND MessageID = @messageId
	)
	-- end function body
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getCIStatusText]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getCIStatusText' AND revision = '1.2.40.1')

  insert into GXDBVersions values(5, 'getCIStatusText',  '1.2.40.1', 'getCIStatusText', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
