

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getAllPermissionsForCategory.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getAllPermissionsForCategory'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getAllPermissionsForCategory]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getAllPermissionsForCategory]
  delete from GXDBVersions where name = 'getAllPermissionsForCategory' and type = 5
END
GO

	CREATE FUNCTION getAllPermissionsForCategory (@categoryId INT,@skipHiddenPermission int =1)
	RETURNS @permissionsTbl TABLE
	(
				categoryId INT,
                permissionId INT
	)
	AS
	BEGIN
                INSERT INTO @permissionsTbl
                                SELECT categoryid, id
                                FROM UMPermissions
                                WHERE categoryId = @categoryId and(@skipHiddenPermission=0 OR flags&0x002=0 )
                                UNION
                                SELECT Perm.categoryid, Perm.permissionId
                                FROM UMCategories AS Cat
                                CROSS APPLY dbo.getAllPermissionsForCategory(Cat.id,@skipHiddenPermission) AS Perm
                                WHERE parentCategoryId = @categoryId
                RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getAllPermissionsForCategory]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getAllPermissionsForCategory' AND revision = '')

  insert into GXDBVersions values(5, 'getAllPermissionsForCategory',  '', 'getAllPermissionsForCategory', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
