

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getAllParentsForCatOrPerm.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getAllParentsForCatOrPerm'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getAllParentsForCatOrPerm]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getAllParentsForCatOrPerm]
  delete from GXDBVersions where name = 'getAllParentsForCatOrPerm' and type = 5
END
GO

	CREATE FUNCTION getAllParentsForCatOrPerm (@categoryId INT, @permissionId INT)
	RETURNS @parentsTbl TABLE
	(
				categoryId INT
	)
	AS
	BEGIN
                IF @permissionId <> 0			--this is a permission
                BEGIN
					INSERT INTO @parentsTbl
						SELECT categoryId		--immediate parent
						FROM UMPermissions
						WHERE id = @permissionId
						UNION
						SELECT Parent.categoryId	--for immediate parent category go recursively to find all parent categories
						FROM UMPermissions AS Perm
						CROSS APPLY dbo.getAllParentsForCatOrPerm(Perm.categoryId, 0) AS Parent
						WHERE Perm.id = @permissionId
                END
                ELSE IF @categoryId <> 0			--this is a category
                BEGIN
					INSERT INTO @parentsTbl			--immediate parent
						SELECT parentCategoryId
						FROM UMCategories
						WHERE id = @categoryId AND parentCategoryId <> 0
						UNION
						SELECT Parent.categoryId	--for immediate parent category go recursively to find all parent categories
						FROM UMCategories AS Cat
						CROSS APPLY dbo.getAllParentsForCatOrPerm(Cat.parentCategoryId, 0) AS parent
						WHERE Cat.id = @categoryId AND Cat.parentCategoryId <> 0
                END
                RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getAllParentsForCatOrPerm]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getAllParentsForCatOrPerm' AND revision = '')

  insert into GXDBVersions values(5, 'getAllParentsForCatOrPerm',  '', 'getAllParentsForCatOrPerm', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
