

--  ------------  Generated from [../../../Source/CommServer/Db/Function/getAllCategoriesRecurXML.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getAllCategoriesRecurXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getAllCategoriesRecurXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getAllCategoriesRecurXML]
  delete from GXDBVersions where name = 'getAllCategoriesRecurXML' and type = 5
END
GO

	CREATE FUNCTION getAllCategoriesRecurXML
	(
		@categoryId INT,
		@localeId INT
	)
	RETURNS XML
	AS
	BEGIN
	DECLARE @returnXML XML
	IF EXISTS( SELECT * from dbo.getAllPermissionsForCategory(@categoryId,1))
	BEGIN
	                       SET @returnXML =(
                                        SELECT(SELECT UMCategories.id AS '@categoryId', dbo.sec_getLocalizedCategory(UMCategories.id, @localeId) AS '@categoryName'
                                                        FOR XML PATH('category'),TYPE),
                                                        (SELECT Perm.id AS '@permissionId', dbo.sec_getLocalizedPermission(Perm.id, @localeId) AS '@permissionName'
                                                        FROM UMPermissions Perm
                                                        WHERE Perm.categoryId = @categoryId and flags&0x002=0
                                                        FOR XML PATH('permissionsList'),TYPE),
                                                        (SELECT dbo.getAllCategoriesRecurXML(Cat1.id, @localeId)
                                                          FROM UMCategories Cat1
                                                          WHERE Cat1.parentCategoryId = @categoryId
                                                          FOR XML PATH(''), TYPE)
                                        FROM UMCategories
                                        WHERE id = @categoryId
                                        FOR XML PATH('categoriesList'))
	END
	RETURN @returnXML
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getAllCategoriesRecurXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getAllCategoriesRecurXML' AND revision = '')

  insert into GXDBVersions values(5, 'getAllCategoriesRecurXML',  '', 'getAllCategoriesRecurXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
