

--  ------------  Generated from [../../../Source/CommServer/Db/Function/fn_EvFormatEventMsgText.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_EvFormatEventMsgText'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_EvFormatEventMsgText]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_EvFormatEventMsgText]
  delete from GXDBVersions where name = 'fn_EvFormatEventMsgText' and type = 5
END
GO

	CREATE FUNCTION fn_EvFormatEventMsgText( @MsgId INTEGER, @LocaleId INTEGER, @EventId INTEGER, @UniqPosition INTEGER, @CCId INTEGER)
	RETURNS NVARCHAR(max)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @MsgTxt		NVARCHAR(max)
		DECLARE @Data		NVARCHAR(max)
		DECLARE @MsgTxtTmp	NVARCHAR(max)
		DECLARE @ArgPos		INTEGER
		DECLARE @ArgIndex	INTEGER
		DECLARE @DataType	INTEGER
		DECLARE @HexFlag	INTEGER
		DECLARE @FullFmtSpecLen	INTEGER
		DECLARE @ParentMask	INTEGER

		SELECT @MsgTxt = Message
		FROM EvLocaleMsgs
		WHERE MessageId = @EventId
		AND LocaleId = @LocaleId

		IF @MsgTxt is null
		BEGIN
			SET @LocaleId = 0				-- If message id not found then try English

			SELECT @MsgTxt = Message
				FROM EvLocaleMsgs
				WHERE MessageId = @EventId
				AND LocaleId = @LocaleId

			IF @MsgTxt is null			-- If even English message not found then error out
			BEGIN
				RETURN @MsgTxt
			END
		END

		SET @ParentMask = @UniqPosition & 0xFFFFFFF0

			DECLARE GetTextPos CURSOR
			LOCAL FAST_FORWARD
			FOR	SELECT ArgPos, ArgIndex, DataType, HexFlag, FullFmtSpecLen
				FROM EvLocaleMsgArgInfo
				WHERE MessageId = @EventId
				AND LocaleId = @LocaleId
				ORDER BY ArgIndex DESC
			FOR READ ONLY

			OPEN GetTextPos

			FETCH NEXT FROM GetTextPos
			INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen

			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @UniqPosition = @ParentMask + @ArgPos

				SELECT @Data = Data FROM EvParam WHERE EvMsgId = @MsgId AND Position = @UniqPosition AND commCellId = @CCId

				IF (@DataType = 13 OR @HexFlag = 1 ) AND ISNUMERIC(@Data) <> 1
				BEGIN
						DECLARE @errorMessage VARCHAR(255) = (SELECT Message FROM EvLocaleMsgs WHERE MessageID = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND LocaleID = @LocaleId)

						SET @MsgTxtTmp = REPLACE(@errorMessage, '^1%s', @Data)

				END
				ELSE
				BEGIN
					IF @DataType = 13		-- Event, Now recurse
						SET @MsgTxtTmp = dbo.fn_EvFormatEventMsgText(@MsgId, @LocaleId, CAST(@Data AS INTEGER), (@UniqPosition*16),@CCId)
					ELSE IF @HexFlag = 1
						SET @MsgTxtTmp = dbo.ConvertBigIntToHexStr(CAST(@Data AS bigint))
					ELSE
						SET @MsgTxtTmp = @Data
				END

				SET @Data = STUFF(@MsgTxt, @ArgIndex, @FullFmtSpecLen, @MsgTxtTmp)
				SET @MsgTxt = @Data		-- Putting this in one statement did not work, something gets overwritten


				FETCH NEXT FROM GetTextPos
				INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen
			END

			CLOSE GetTextPos
			DEALLOCATE GetTextPos

		RETURN @MsgTxt
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_EvFormatEventMsgText]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_EvFormatEventMsgText' AND revision = '1.10.210.4')

  insert into GXDBVersions values(5, 'fn_EvFormatEventMsgText',  '1.10.210.4', 'fn_EvFormatEventMsgText', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
